#=====================
# XDG Menu Functions
# By QB89Dragon 2007/8
# This does not run independently
#=====================
import gconf
import optparse
import os
import urllib
import xml.dom.minidom
import string

import xdg.Menu
import xdg.IconTheme
import xdg.Locale
from xdg.DesktopEntry import *

import Globals
import Config

class XDGMenu:
	def __init__(self):
		self.BaseMenu = xdg.Menu.parse("applications.menu")
		self.Menu = self.BaseMenu
		self.PrevMenu = []
		self.searchresults = 0

		#This loads the icon cache
		self.IconCachePath = Config.HomeDirectory + "/.menuiconcache.xml"
		self.IconNames = []
		self.Icons = []
		if os.path.isfile(self.IconCachePath):
			try:
				XMLSettings = xml.dom.minidom.parse(self.IconCachePath)
				XBase = XMLSettings.childNodes[0].getElementsByTagName("Icon")
				for node in XBase:
					self.IconNames.append(node.attributes["IconNames"].value)
					self.Icons.append(node.attributes["Icons"].value)
			except:
				print "[XDG] Recoverable Error: Loading of icon cache has failed! This could be due to a corrupted file or read permissions."
		self.ConstructMenu()

	def ConstructMenu(self):
		self.L_Names = []
		self.L_Icons = []
		self.L_Types = []
		self.L_Paths = []
		self.L_Execs = []
		self.searchresults = 0
		if Config.Shownetandemail == 1:
			self.AddInternetButtons()
		
		#==============================================================
		#AUXILIARY FUNCTIONS MENU
		#==============================================================

		if self.Menu == "<AuxiliaryFunctions>":
			self.L_Names.append("""About Me
Change user profile settings""")
			self.L_Icons.append("user-info")
			self.L_Types.append(5)
			self.L_Paths.append("")
			self.L_Execs.append("gnome-about-me")

			self.L_Names.append("""Appearance
Change appearance settings""")
			self.L_Icons.append("gnome-settings-theme")
			self.L_Types.append(5)
			self.L_Paths.append("")
			self.L_Execs.append("gnome-appearance-properties")
			
			self.L_Names.append("""Menu editor
Modify your start menu""")
			self.L_Icons.append("alacarte")
			self.L_Types.append(6)
			self.L_Paths.append("")
			self.L_Execs.append("alacarte")

			self.L_Names.append("""Screensaver
A legacy of phosphor""")
			self.L_Icons.append("screensaver")
			self.L_Types.append(5)
			self.L_Paths.append("")
			self.L_Execs.append("gnome-screensaver-preferences")
			
			self.L_Names.append("""System Monitor
Processes and performance""")
			self.L_Icons.append("gnome-system-monitor")
			self.L_Types.append(5)
			self.L_Paths.append("")
			self.L_Execs.append("gnome-system-monitor")

			self.L_Names.append("""Vista Menu
Manage this menu utility""")
			self.L_Icons.append(Config.GraphicsDirectory + "logo.png")
			self.L_Types.append(7)
			self.L_Paths.append("")
			self.L_Execs.append(Config.ProgramDirectory+"Vista-Menu-Settings.py")

		#==============================================================
		#RECENT ITEMS MENU
		#==============================================================
		
		elif self.Menu == "<RecentItems>":
			self.RIMenu = xml.dom.minidom.parse(Config.HomeDirectory + "/.recently-used.xbel")
			self.RIlength = self.RIMenu.getElementsByTagName("bookmark").length * 2 - 1
			self.RIt = self.RIMenu.childNodes[0]
			i = 0
			j = 0
			while (j <= Config.RI_numberofitems-1 and i*2 <= self.RIlength):
				self.RItv = self.RIt.childNodes[self.RIlength - i * 2].attributes["href"]
				self.RInames = self.RItv.value
				self.RInames = urllib.url2pathname(self.RInames)
				self.RInames = self.RInames.replace("file://","")
				self.RInames = self.RInames.replace("%U","")
				self.RInames = self.RInames.replace("%F","")
				self.RInamess2 = self.RInames.split("/")
				self.RInamess = self.RInamess2.pop()
				i = i + 1
				if os.path.isfile(self.RInames):
					self.L_Names.append(self.RInamess)
					self.L_Icons.append("fileopen")
					self.L_Types.append(3)
					self.L_Paths.append("")
					self.L_Execs.append(self.RInames)
					j = j + 1
				elif os.path.isdir(self.RInames):
					self.L_Names.append(self.RInames)
					self.L_Icons.append("folder")
					self.L_Types.append(3)
					self.L_Paths.append("")
					self.L_Execs.append(self.RInames)
					j = j + 1
		elif isinstance(self.Menu, xdg.Menu.Menu):
		
		#==============================================================
		#XDG PROGRAMS MENU
		#==============================================================
		
			for entry in self.Menu.getEntries():
				if isinstance(entry, xdg.Menu.Menu):		#Folder
					self.L_Names.append(entry.getName())
					self.L_Icons.append(entry.getIcon())
					self.L_Types.append(0)
					self.L_Paths.append(entry.getPath(True))
					self.L_Execs.append("")
				elif isinstance(entry, xdg.Menu.MenuEntry):	#Application
					self.app = DesktopEntry(entry.DesktopEntry.getFileName())
					self.L_Names.append(self.app.getName())
					self.L_Icons.append(self.app.getIcon())
					self.L_Types.append(1)
					self.L_Paths.append("")
					self.L_Execs.append(self.app.getExec())
		else:
		#==============================================================
		#XDG PROGRAMS MENU (SEARCH)
		#==============================================================
			#self.searchresults = 0
			for entry in self.BaseMenu.getEntries():
				
				if isinstance(entry, xdg.Menu.Menu):		#Folder
					self.sname = str(entry.getName())
					self.sname = self.sname.upper()
					if self.sname.count(self.Menu) != 0:
						self.L_Names.append(entry.getName())
						self.L_Icons.append(entry.getIcon())
						self.L_Types.append(0)
						self.L_Paths.append(entry.getPath(True))
						self.L_Execs.append("")
						self.searchresults=self.searchresults+1
					self.SearchMenu(self.BaseMenu.getMenu(entry.getPath(True)))
				elif isinstance(entry, xdg.Menu.MenuEntry):	#Application
					self.app = DesktopEntry(entry.DesktopEntry.getFileName())
					self.sname = str(self.app.getName())
					self.sname = self.sname.upper()
					if self.sname.count(self.Menu) != 0:
						self.L_Names.append(self.app.getName())
						self.L_Icons.append(self.app.getIcon())
						self.L_Types.append(1)
						self.L_Paths.append("")
						self.L_Execs.append(self.app.getExec())
						self.searchresults=self.searchresults+1
			if self.searchresults==0:
				self.L_Names.append("No items matched your search criteria")
				self.L_Icons.append("")
				self.L_Types.append(9)
				self.L_Paths.append("")
				self.L_Execs.append("")
			else:
				self.L_Names.append("Found "+str(self.searchresults) + " results to your search")
				self.L_Icons.append("")
				self.L_Types.append(9)
				self.L_Paths.append("")
				self.L_Execs.append("")
				
		#Add back button so long as it isn't the base XDG menu
		if isinstance(self.Menu, xdg.Menu.Menu):
			if self.Menu.getName() !="Applications":
				self.AddBackButton()
		else:
			self.AddBackButton()

	def SearchMenu(self, folder):
		for entry in folder.getEntries():
			
			if isinstance(entry, xdg.Menu.Menu):		#Folder
				self.sname = str(entry.getName())
				self.sname = self.sname.upper()
				if self.sname.count(self.Menu) != 0:
					self.L_Names.append(entry.getName())
					self.L_Icons.append(entry.getIcon())
					self.L_Types.append(0)
					self.L_Paths.append(entry.getPath(True))
					self.L_Execs.append("")
					self.searchresults=self.searchresults+1
				self.SearchMenu(self.BaseMenu.getMenu(entry.getPath(True)))
			elif isinstance(entry, xdg.Menu.MenuEntry):	#Application
				self.app = DesktopEntry(entry.DesktopEntry.getFileName())
				self.sname = str(self.app.getName())
				self.sname = self.sname.upper()
				if self.sname.count(self.Menu) != 0:
					self.L_Names.append(self.app.getName())
					self.L_Icons.append(self.app.getIcon())
					self.L_Types.append(1)
					self.L_Paths.append("")
					self.L_Execs.append(self.app.getExec())
					self.searchresults=self.searchresults+1

	def AddInternetButtons(self):
		#Add Internet and Email buttons
		gconf_client = gconf.client_get_default()
		self.client = gconf_client.get_string("/desktop/gnome/applications/browser/exec")
		# FIXME Languages
		self.L_Names.append(Config.Lang['MenuInternet'])
		self.L_Icons.append(Config.Browser)
		self.L_Types.append(1)
		self.L_Paths.append("")
		self.L_Execs.append(self.client)
		
		self.client = gconf_client.get_string("/desktop/gnome/url-handlers/mailto/command")
		self.L_Names.append(Config.Lang['MenuMail'])
		self.L_Icons.append(Config.Email)
		self.L_Types.append(1)
		self.L_Paths.append("")
		self.L_Execs.append(self.client)

		self.L_Names.append("<separator>")
		self.L_Icons.append("")
		self.L_Types.append(8)
		self.L_Paths.append("")
		self.L_Execs.append("")
		
	def AddBackButton(self):
		self.L_Names.append("<separator>")
		self.L_Icons.append("")
		self.L_Types.append(8)
		self.L_Paths.append("")
		self.L_Execs.append("")

		self.L_Names.append(Config.Lang['MenuBack'])	#FIXME Languages
		self.L_Icons.append("back")
		self.L_Types.append(2)
		self.L_Paths.append("")
		self.L_Execs.append("")
		

	def ButtonClick(self,index):
		self.etype = self.L_Types[index]
		if self.etype == 0:     				#Subfolder
			self.PrevMenu.append(self.Menu)
			self.Menu = self.BaseMenu.getMenu(self.L_Paths[index])
			self.ConstructMenu()
		elif self.etype == 1:                   #Application
			print "launching item from application list..."
			self.expl = self.L_Execs[index].split()
			#if last item in list begins with the character "%" then remove it and add it after the ' mark
			self.outcommand = ""
			if "%" in self.expl[len(self.expl)-1]:
				self.outcommand = " " +  self.expl.pop()
			self.expls = string.join(self.expl,' ')
			self.expls = "/bin/sh -c '" + self.expls +"'"+self.outcommand
			os.system(self.expls+' &')
			return 1
		elif self.etype == 2:                                   #Menu Back button
			self.Menu = self.PrevMenu.pop()
			self.ConstructMenu()
		elif self.etype == 3:                                   #Recent Items button (file)
			os.system("gnome-open '"+self.L_Execs[index]+"' &")
		elif self.etype == 4:                                                   #Recent Items button (directory)
			os.system("nautilus '"+self.L_Execs[index]+"' &")
		elif self.etype == 5:                                                       #Launch straight file from execlist (NoWait)
			os.system("/bin/sh -c '" + self.L_Execs[index]+"' &")
		elif self.etype == 6:                                                   #Items in the menu have changed
			os.system("/bin/sh -c '" + self.L_Execs[index]+"' &")
		elif self.etype == 7:                                                   #Properties of the menu have changed
			os.system("/bin/sh -c '" + self.L_Execs[index]+"' &")
			Config.ReloadSettings()
			
	def geticonfile(self,icon):
		#Returns system icon paths
		
		# This code caches icons after the first load so they don't need to get reloaded
		for i in range(0,len(self.IconNames)):
			if self.IconNames[i] == icon:
				return self.Icons[i]
		
		iconpath = xdg.IconTheme.getIconPath(icon, Config.PG_iconsize, Config.DefaultIconTheme, ["png", "xpm", "svg"])
		if not iconpath:
			iconpath = "/usr/share/icons/application-default-icon.png"
		self.IconNames.append(icon)
		self.Icons.append(iconpath)
		return iconpath

	def CallSpecialMenu(self,command,data=None):
		if command==0:	#Back button
			if self.PrevMenu:
				self.Menu = self.PrevMenu.pop()
				self.ConstructMenu()
		elif command==1:	#Go to base menu and reload it
			self.PrevMenu = []
			self.BaseMenu = xdg.Menu.parse("applications.menu")
			self.Menu=self.BaseMenu
			self.ConstructMenu()
		elif command==2:	#Go to unmount drives menu
			self.Menu = "<UnmountDrives>"
			print "not yet implamented"
		elif command==3:	#Auxiliary functions menu
			self.PrevMenu.append(self.Menu)
			self.Menu = "<AuxiliaryFunctions>"
			self.ConstructMenu()
		elif command==4:	#Recent Items Menu
			self.PrevMenu.append(self.Menu)
			self.Menu = "<RecentItems>"
			self.ConstructMenu()
		elif command==5:	#Search
			if data!="":
				self.PrevMenu = [self.BaseMenu]
				self.Menu=data.upper()
				self.ConstructMenu()
			else:
				self.PrevMenu = []
				self.Menu=self.BaseMenu
				self.ConstructMenu()
		elif command==6:	#Launch first item in search list
			if self.searchresults!=0:
				if Config.Shownetandemail == 1:
					self.ButtonClick(3)
				else:
					self.ButtonClick(0)
	
	def destroy(self):
		print "Saving Icon Cache..."
		#Save Imagecache
		XMLSettings = xml.dom.minidom.Document()
		XBase = XMLSettings.createElement("cache")
		XMLSettings.appendChild(XBase)
		for icon in range(0,len(self.IconNames)):
			node = XMLSettings.createElement("Icon")
			node.setAttribute("IconNames", self.IconNames[icon])
			node.setAttribute("Icons", self.Icons[icon])
			XBase.appendChild(node)
		#Now write it to the file
		file = open(self.IconCachePath,"w")
		XMLSettings.writexml(file, "    ", "", "\n", "UTF-8")
		XMLSettings.unlink()
		print "XDG: Icon cache successfully written to user's home directory"		
