#===========================
# Panel Applet Code for Menu
# By QB89Dragon 2007/8
# This does not run independently
#===========================

import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import sys
import gobject
import gnomeapplet
import gnome.ui
import dbus
import dbus.glib 
import os.path
import Globals
#import gconf
import re
import Config
from Vista_Menu_Main import Main_Menu
from Cairo_Button_Window import CairoButtonWindow
import Globals as pglobals
# Depends on Tomboy notes
sys.path.append('/usr/lib/python2.5/site-packages/deskbar/core/keybinder')
from _keybinder import tomboy_keybinder_bind as bindkey

class VistaMenu(gnomeapplet.Applet):
    global Config
    global Button_state
    def __init__(self,applet,iid):
		#Initialise Menus
		#ConstructMainMenu()
		#self.__gobject_init__()
		self.timeout_interval = 200
		self.tooltip_text = "Consolidated menu for the Gnome desktop"
		# Initialise Gnome
		gnome.init(Globals.name, Globals.version)
		# Initialise Button
		self.Button_state = 0
		self.screenstate = 0
		# 0 = No change  1 = Mouse over  2 = Depressed
		# Initialise GTK Interface
		self.propxml="""
        <popup name="button3">
        <menuitem name="Item 1" verb="Props" label='"""+Config.Lang['PrefLabel']+"""' pixtype="stock" pixname="gtk-properties"/>
        <menuitem name="Item 2" verb="About" label='"""+Config.Lang['AboutLabel']+"""' pixtype="stock" pixname="gnome-stock-about"/>
        <menuitem name="Item 3" verb="Edit" label='"""+Config.Lang['MenuEditLabel']+"""' pixtype="stock" pixname="alacarte"/>
		</popup>
		"""

		self.verbs = [ ( "Props", self.properties ),
					   ( "About", self.about_info ),
					   ( "Edit", self.edit_menus)  
				 ]

		self.applet = applet
		self.orientation = self.applet.get_orient()
		# Frame for custom placement of objects
		self.Main_icon_box = gtk.Fixed()
		self.applet.add(self.Main_icon_box)
		# Hook events
		self.ev_box = gtk.EventBox()
		self.ev_box.connect("button-press-event",self.button_press)
		self.ev_box.connect("enter-notify-event", self.select_box)
		self.ev_box.connect("leave-notify-event", self.deselect_box)
		self.ev_box.set_visible_window(0)
		
		# DBus Menu Activation
		session_bus = dbus.SessionBus()
		session_bus.add_signal_receiver(self.ToggleMenu,None,'org.qb89dragon.vistamenu')

		# Hotkey Menu Activation
		if Config.SuperL == "1":
			os.system("xmodmap -e 'keycode "+str(Config.SuperLkey)+" = Super_L'")
			bindkey("Super_L", self.ToggleMenu)

		# FIXME: Add event for when applet is moved on panel to enable orb top to follow!!!
		# This is currently set to reorientate itself whenever it is clicked as a temp workaround.
		#self.applet.connect("property-change-event",self.window_moved)
		# Place GTK Image
		self.Main_icon_box.put(self.ev_box,-1,-1)
		# Set the image of the panel button
		self.image_icon = gtk.Image()
		self.image_icon.set_from_file(Config.StartButton[self.Button_state])
		# Add Image to event object
		self.ev_box.add(self.image_icon)
		#Timeout signal
		gobject.timeout_add(self.timeout_interval,self.timeout_callback, self)
		#Destroy signal
		self.applet.connect("destroy",self.cleanup)
		if Config.ShowTop == 1:
			#Create auxiliary window (CAIRO)
			self.aux = CairoButtonWindow()
			self.aux.aux_window.connect("enter-notify-event", self.select_box)
			self.aux.aux_window.connect("leave-notify-event", self.deselect_box)
			self.aux.aux_window.connect("button-press-event",self.button_press)

		#Show all created windows
		self.applet.show_all()
		#Show welcome screen on first run
		#Launch the welcome screen
		if Config.FirstUse:
			os.system("/bin/sh -c '/usr/lib/"+Globals.appdirname+"/Vista-Menu-Settings.py --welcome' &")
		

    def auxdestroyed(self):	
    #Respawn point for the aux window if it has been Alt-F4ed
	if Config.ShowTop == 1:
            #Used in this instance for providing delay for window to be created
            self.aux = CairoButtonWindow()
            #self.aux.Create(self, 0)     #Create the orb top
            self.aux.updateimage(Config.StartButtonTop[self.Button_state + self.screenstate])
            

    def button_press(self,widget,event):
        if event.button == 1:
            # Remove this next line when orb top repositioning on widget move is fixed
            if Config.ShowTop == 1:
                pass
                #self.window_moved(self.aux)
            if self.Button_state == 2:
                self.HideMenu()
                self.Button_state = 1
            else:
                self.Button_state = 2
                self.Redraw_graphics()
                self.ShowMenu()
                
            self.Redraw_graphics()
        elif event.button == 3:
            self.create_menu()
            
            
    def create_menu(self):
        self.applet.setup_menu(self.propxml,self.verbs,None)
            
    def about_info(self,event,data=None):
        self.Applogo = gtk.gdk.pixbuf_new_from_file(Config.Applogo)
        credits = open(Config.ProgramDirectory + 'translators.txt')
        creditstext = credits.read()
        about = gnome.ui.About(Globals.name,pglobals.version,"GPL","Consolidated menu for the GNOME desktop.",["Chris Hughes (aka. qb89dragon) <hughescih@hotmail.com>", "Feel free to send the dragon food and money. He is always hungry. Please donate with paypal to 89dragon@gmail.com","========","[nXn]NeiroN neiron@idz.ru - Config Dialog And Lang Support","good idea!!! - bad code"],["Nobody."],creditstext, self.Applogo)
        about.show()

    def properties(self,event,data=None):
        global Config
        os.system("/bin/sh -c '"+Config.ProgramDirectory+"Vista-Menu-Settings.py' &")
        # Fixme, reload stuff properly
        Config.ReloadSettings()
        
    def select_box(self,widget,event):
        if self.Button_state == 0:
            self.Button_state = 1
        self.Redraw_graphics()
        
    def deselect_box(self,widget,event):
        if self.Button_state == 1:
            self.Button_state = 0
        self.Redraw_graphics()
        
    def Redraw_graphics (self):
        self.image_icon.set_from_file(Config.StartButton[self.Button_state])
        if Config.ShowTop == 1:
            self.aux.updateimage(Config.StartButtonTop[self.Button_state + self.screenstate])
        self.applet.queue_draw()

    def timeout_callback(self,event):
		if Config.ShowTop == 1:
			#Used in this instance for providing delay for window to be created
			#self.aux.Create(self, 0)     #Create the orb top (FIXME!!)
			self.aux.updateimage(Config.StartButtonTop[self.Button_state + self.screenstate])
			self.Update_Panel_Geometry()
		# Create the menu (hidden)
		self.hwg = Main_Menu(self.HideMenu)
		origin = self.applet.window.get_origin()
		self.hwg.setup(origin[0], origin[1])
		Config.SavedOriginState = origin

        
    def cleanup(self,event):
        print "cleanup"
        self.hwg.destroy()
        if Config.ShowTop == 1:
		Config.ShowTop = 0
	        self.aux.destroy()
        #gtk.main_quit()
        del self.applet
    
    def edit_menus(self,event, data=None):
        os.spawnvp(os.P_WAIT,"alacarte",["alacarte"])
        #ConstructMainMenu()

    def ToggleMenu(self):
		if self.Button_state == 2:
			self.Button_state = 0
			self.Redraw_graphics()
			self.HideMenu()
		else:
			self.Button_state = 2
			self.Redraw_graphics()
			self.ShowMenu()


    def ShowMenu(self):
		# Display the start menu!!!
		origin = self.applet.window.get_origin()
		if origin != Config.SavedOriginState:
			self.hwg.Adjust_Window_Dimensions(origin[0],origin[1])
		self.hwg.show_window()
		#self.hwg.grab_focus()
	
    def HideMenu(self):
		self.hwg.hide_window()
		self.Button_state = 0
		self.Redraw_graphics()

    def Update_Panel_Geometry(self,widget=None, event=None):
    	# Get Panel Info
		self.ev_box_parent_window = self.ev_box.get_parent_window()
		self.applet_rect = self.ev_box_parent_window.get_frame_extents()
		# Calculate the panel top offset point
		# Placement parameters    FIXME This should be loaded from XML
		#StartButtonTopWidth = 40
		
		StartButtonTopHeight = self.aux.get_height()
		print StartButtonTopHeight
		print self.applet_rect.height
		self.StartButtonXOffset = 1
		self.StartButtonYOffset = 1 - StartButtonTopHeight 

        # Responding to main applet movement and panel height
		print "Reorientating Orb top!! (Don't let this happen too often!!)"
		origin = self.applet.window.get_origin()
		Window_x =  origin[0] + self.StartButtonXOffset
		Window_y =  origin[1] + self.StartButtonYOffset
		# Calculate midpoint of screen
		self.screenmidpty = int(Config.screenheight / 2)
		# Work out orientation of panel 
		self.screenstate = 0 		# FIXME MAKE THIS WORK!
		self.aux.move(Window_x,Window_y)
