#!/usr/bin/env python 
#=====================
# Menu window
# By QB89Dragon 2007/8
#=====================
import sys
import pygtk
pygtk.require("2.0")
import gtk
#import gtk.glade
import gobject
import Config
#import cairo
#import pango
import os
#import gconf
import string

from Cairo_Window import CairoWindow
#Dynamically import selected theme module
exec "sys.path.append('"+Config.PGThemeDirectory+"')"
exec "from PGMenu import ProgramList"

if Config.SearchWidget == "Custom":
	#Dynamically import custom searchbar widget
	exec "sys.path.append('"+Config.ImageDirectory+"')"
	exec "from " + Config.SearchWidgetPath + " import SearchBar"
	gobject.type_register(SearchBar)

# Class for a button object from menu
class MenuButton:
    def __init__(self,i,base,backimage):
        self.Button = gtk.EventBox()
        self.Frame = gtk.Fixed()
        self.Button.add(self.Frame)
        if Config.MenuButtonIcon[i]:
        	self.Icon = gtk.Image()
        	self.SetIcon(Config.ImageDirectory + Config.MenuButtonIcon[i])
        # Set the top image
        self.Image = gtk.Image()
       	self.Setimage(Config.ImageDirectory + Config.MenuButtonImage[i])
        
        # Clip the background from the back image
        self.w = self.Pic.get_width()
        self.h = self.Pic.get_height()
        # Grab the background pixels from under the location of the menu button
        self.backimagearea = backimage.subpixbuf(Config.MenuButtonX[i],Config.MenuButtonY[i],self.w,self.h)
        # Set the background which is always present
        self.Background = gtk.Image()
        self.Background.set_from_pixbuf(self.backimagearea)
        
        self.SetBackground()
        self.Frame.put(self.Background,0,0)
        self.Frame.put(self.Image,0,0)
        if Config.MenuButtonIcon[i]:
        	self.Frame.put(self.Icon,0,0)
        self.Label = gtk.Label()
        self.Label.set_markup(Config.MenuButtonMarkup[i])
        self.Frame.put(self.Label,Config.MenuButtonNameOffsetX[i],Config.MenuButtonNameOffsetY[i])
        base.put(self.Button,Config.MenuButtonX[i],Config.MenuButtonY[i])

    def SetIcon(self,filename):
        # If the menu has an icon on top, then add that
		self.Pic = gtk.gdk.pixbuf_new_from_file(filename)
		self.Icon.set_from_pixbuf(self.Pic)
				

    def Setimage(self,imagefile):
        # The image is background when it's not displaying the overlay
        self.Pic = gtk.gdk.pixbuf_new_from_file(imagefile)
        self.Image.set_from_pixbuf(self.Pic)

    def SetBackground(self):
    	self.Image.set_from_pixbuf(self.backimagearea)
    

class Separator:
    def __init__(self,i,base):
        self.Image = gtk.Image()
        self.Setimage(Config.ImageDirectory + Config.MenuButtonImage[i])
        base.put(self.Image,Config.MenuButtonX[i],Config.MenuButtonY[i])

    def Setimage(self,imagefile):
        self.Pic = gtk.gdk.pixbuf_new_from_file(imagefile)
        self.Image.set_from_pixbuf(self.Pic)

class Main_Menu:
    def __init__(self, hide_method):
		self.hide_method = hide_method
		#Set the main working directory to home
		os.chdir(Config.HomeDirectory)
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.window.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_MENU)
		self.window.set_app_paintable(1)
		self.window.set_skip_taskbar_hint(1)
		self.window.set_skip_pager_hint(1)
		self.window.set_decorated(0)
		self.window.set_keep_above(0)       #Make this always above other windows
		self.window.stick()                 #Make this appear on all desktops
		self.window.set_default_size(Config.MenuWidth,Config.MenuHeight)

		if Config.MenuHasIcon==1:
			# Set up the user icon
			self.usericon = CairoWindow(Config.IconW,Config.IconH,Config.IconInX,Config.IconInY,Config.IconInW,Config.IconInH)
			self.usericonstate = 0
			self.LastUserPicName = ""

		self.window.connect("destroy", gtk.main_quit)	#Fixme?
		self.window.connect("focus-out-event", self.hide_window_event)
		self.window.connect("key-press-event", self.key_down)
		    
    def auxdestroyed(self):
        #dummy sub for module compatibility
        pass
    
    def destroy(self):
        # External Obliterator
        self.PGL.destroy()
        
        #if Config.MenuHasIcon == 1:
            #self.usericon.destroy(None)
        #self.window.destroy()
        #gtk.main_quit()
        
    def internal_destroy(self,widget,event):
        # Internal Obliterator (event driven)
        self.PGL.destroy()
        
        #if Config.MenuHasIcon == 1:
         #   self.usericon.destroy(None)
		#self.window.destroy()
        #gtk.main_quit()

#=================================================================
#WINDOW SETUP
#=================================================================

    def setup(self,win_x, win_y):
		#Standard setup of window
		self.Adjust_Window_Dimensions(win_x,win_y)
		# Set up the UserPic
		self.ChangeUserPic_Normalise()

		# Set up GTK Menu
		self.menuframe = gtk.Fixed()
		self.window.add (self.menuframe)
		

		# Set menu background image
		self.background =  gtk.Image()
		self.menuframe.put(self.background,0,0)

		# Set window shape from alpha mask of background image
		self.bgpb = gtk.gdk.pixbuf_new_from_file(Config.ImageDirectory + Config.StartMenuTemplate)
		self.bgpbim, self.bgpbms = self.bgpb.render_pixmap_and_mask(alpha_threshold=128)
		self.background.set_from_pixmap(self.bgpbim, self.bgpbms)
		
		#self.window.input_shape_combine_mask(self.bgpbms,0,0)
		self.window.shape_combine_mask(self.bgpbms, 0, 0)
		
		#Menu Buttons
		self.MenuButtons = []
		for i in range(0,Config.MenuButtonCount):
			if Config.MenuButtonNames[i] == ":SEPARATOR:":
				self.MenuButtons.append(Separator(i,self.menuframe))
			else:
				self.MenuButtons.append(MenuButton(i,self.menuframe,self.bgpb))
				self.MenuButtons[i].Button.connect("enter-notify-event", self.Button_enter)
				self.MenuButtons[i].Button.connect("leave-notify-event", self.Button_leave)
				self.MenuButtons[i].Button.connect("button-release-event", self.Button_click)
			
		# Configure the Program List
		self.PGL = ProgramList()
		self.PGL.ProgramListPopulate(self.menuframe, self.hide_method)
		# Pass widget focus to the text entry box
		if Config.MenuHasSearch:
			if Config.SearchWidget == "Custom":
				if Config.SearchBackground:
					self.SearchBar =  SearchBar(Config.ImageDirectory + Config.SearchBackground,Config.SearchInitialText,Config.SearchIX,Config.SearchIY)#gtk.Entry()
				else:
					self.SearchBar =  SearchBar(None,Config.SearchInitialText,Config.SearchIX,Config.SearchIY)
			elif Config.SearchWidget == "GTK":
				self.SearchBar = gtk.Entry()
				
			self.SearchBar.set_size_request(Config.SearchW, Config.SearchH)
			self.menuframe.put(self.SearchBar, Config.SearchX, Config.SearchY)
			#self.SearchBar.connect("activate",self.SearchBarActivate)
			self.SearchBar.connect("key-release-event",self.SearchBarActivate)
			self.prevsearchitem = ""
			
    def Adjust_Window_Dimensions(self, win_x, win_y):
		tmp = self.window.get_size()
		win_x = win_x + Config.StartMenuXOffset

		# Change from beta 1, make it go down if in the top part of the screen
		# May want to adjust theme to make it look prettier when doing this tho

		self.screenmidpty = int(Config.screenheight / 2)
		if win_y < self.screenmidpty:
			win_y = win_y - Config.StartMenuYOffset
		else:
			win_y = win_y - tmp[1] + Config.StartMenuYOffset
		self.win_x = win_x
		self.win_y = win_y
		self.window.move(win_x, win_y)
		

    def show_window(self):
		# This will fail if focus stealing prevention is enabled!
		if Config.MenuHasIcon==1:
			self.usericon.show_window()
		self.ChangeUserPic_Normalise()
		self.window.show_all()
		self.window.present()
		# FIXME: Usericon fails to appear in front of menu in metacity WM
		
		
    def hide_window_event(self,widget,event):
		# This will fail if focus stealing prevention is enabled!
		self.hide_method()
		
    def hide_window(self):
		self.window.hide()
		if Config.MenuHasIcon==1:
			self.usericon.hide_window()
		self.PGL.CallSpecialMenu(1)
		if Config.MenuHasSearch:
			self.SearchBar.set_text("")
		
    def key_down (self,widget,event):
    	# Focus mapping and key press management
		# (this is not the only key event routine set for the menu, also check the PGMenu routines)
		key = event.hardware_keycode
		if key == 9:	#Escape Key, hides window
			self.hide_method()
		elif key == 98 or key == 104 or key == 102 or key == 100 or key == 36:
			# Menu naviagation keys give focus to program list
			if Config.MenuHasSearch:
				if self.SearchBar.is_focus() == True:
					if key==36 and self.PGL.XDG.searchresults!=0: # Enter on searchbar launches first item in search list
						self.PGL.CallSpecialMenu(6)
						self.hide_method()
					self.PGL.BanFocusSteal = False
					self.PGL.SetInputFocus()
		else:	#Any other key passes through to search bar
			if Config.MenuHasSearch:
				if self.SearchBar.is_focus() == False:
					self.SearchBar.grab_focus()
				self.SearchBarActivate()

#=================================================================
#Menu Buttons
#=================================================================
    def Button_enter(self,widget,event):
    	# Change button background
		i = self.GetButtonIndex(widget)
		self.MenuButtons[i].Setimage(Config.ImageDirectory + Config.MenuButtonImage[i])
		if Config.MenuButtonIconSel[i]:
			self.MenuButtons[i].SetIcon(Config.ImageDirectory + Config.MenuButtonIconSel[i])
		# User Icon Code 
		# fixme: no support for non fade icons
		if Config.MenuCairoIcon[i]:
			if Config.MenuHasIcon == 1 and Config.MenuHasFade == 1:
				self.UserPicName = Config.IconDirectory + Config.MenuCairoIcon[i]
				if self.LastUserPicName!=self.UserPicName:
					self.LastUserPicName=self.UserPicName
					#self.usericon.iconopacity = [0,0,1,0]
					if self.usericonstate == 0:
						self.usericon.transition([-1,-1,1,0],Config.TransitionS,Config.TransitionQ,None)
						self.usericon.updateimage(2,self.UserPicName)
					elif self.usericonstate == 1:
						self.usericon.updateimage(3,self.UserPicName)
						self.usericon.transition([-1,-1,-1,1],Config.TransitionS,Config.TransitionQ,None)
					elif self.usericonstate == 2:
						self.usericon.updateimage(2,self.UserPicName)
						self.usericon.transition([-1,-1,1,-1],Config.TransitionS,Config.TransitionQ,None)
					if self.usericonstate == 1:
						self.usericonstate = 2
					else:
						self.usericonstate = 1
		
    def Button_leave(self,widget,event):
    	# Button background
		i = self.GetButtonIndex(widget)
		self.MenuButtons[i].SetBackground()
		if Config.MenuButtonIcon[i]:
			self.MenuButtons[i].SetIcon(Config.ImageDirectory + Config.MenuButtonIcon[i])
		# User Icon code
		self.LeaveCustomState()
	
    def GetButtonIndex(self,widget):
    	#Get index from event box
		for i in range(0,Config.MenuButtonCount):
			if Config.MenuButtonNames[i] != ":SEPARATOR:":
				if self.MenuButtons[i].Button == widget:
					return i

    def Button_click(self,widget,event):
    	i = self.GetButtonIndex(widget)

    	# Launch standard menu command
    	if Config.MenuButtonSub[i] == 0:

			self.k = self.LookUpCommand(Config.MenuButtonCommands[i])
			self.k = string.replace(self.k, "[home]", Config.HomeDirectory)
			os.system("/bin/sh -c '" + self.k + "' &")
     	else:
			self.PGL.CallSpecialMenu(int(Config.MenuButtonCommands[i]))
			
		# Close menu if specified by theme
        if Config.MenuButtonClose[i] == 1:
            self.hide_window()

    def LookUpCommand(self,command):
    	for i in range(0,len(Config.MenuActions)):
			if Config.MenuActions[i]==command:
				return Config.MenuCommands[i]
    	print "Unrecognised Menu Button Command. Check theme settings are accurate and make sure you are using the latest version of the menu."
    	return ""

#=================================================================
#USERICON METHODS
#=================================================================
    def LeaveCustomState(self):	#FIXME This is for fade back to normal, CUP_Norm is for quick switching
        if Config.MenuHasIcon == 1:
            self.ChangeUserPic_Normalise()

    def ChangeUserPic_Normalise(self):
        # Restore userpic to mode 2  (speed lag if overwriting already current values)
        # Place the usericon        
        if Config.MenuHasIcon == 1:
			self.usericon.move(self.win_x + Config.UserIconFrameOffsetX,self.win_y  + Config.UserIconFrameOffsetY)
			self.usericon.updateimage(0,Config.UserImageFrame)
			self.usericon.updateimage(1,Config.UserImage)
			#self.usericon.iconopacity = [1,1,0,0]
			self.usericon.transition([1,1,-1,-1],Config.TransitionS,Config.TransitionQ,None)
			self.usericonstate == 0
			self.LastUserPicName = ""
			self.usericon.Redraw()
            
#=================================================================
#SEARCH BAR
#=================================================================
    def SearchBarActivate(self,widget=None,event=None):
        self.searchitem = self.SearchBar.get_text()
        if self.prevsearchitem != self.searchitem:
			self.PGL.BanFocusSteal = True
			self.prevsearchitem = self.searchitem
			self.PGL.CallSpecialMenu(5,self.searchitem)

# Code to launch menu standalone of base classes

def destroy():
	hwg.destroy()
	sys.exit()
	
if __name__ == "__main__":
    hwg = Main_Menu(destroy)
    hwg.setup(0,0)
    hwg.show_window()
    gtk.main()
    



