#!/usr/bin/env python
#=====================
# Settings Window
# By QB89Dragon 2007/8
#=====================

import sys
import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import gobject
import Globals
import xml.dom.minidom
import os

def fixsettings(widget=None,event=None):
	os.system("cp /usr/lib/"+Globals.appdirname+"/Settings_default.xml " + os.path.expanduser("~") + "/.VistaMenuSettings.xml")
	# Give it a second shot now
	try:
		import Config
		global Config
		#a = 9/0 # Force an error to occur for testing
	except:
		from error_message import Message
		a = Message("Reverting to default settings seems to have failed to resolve the issue. Please run from a terminal 'Vista_Menu.py run-in-window' and copy and paste the output to the gnome-look.org page where you downloaded the menu to help with debugging.",Globals.name, cancelfixsettings, cancelfixsettings, 1)
		a.window.destory()
	gtk.main_quit()
		
def cancelfixsettings(widget=None,event=None):
	sys.exit()
try:
	import Config
except:
	from error_message import Message
	a = Message("The "+Globals.name+" settings file has been corrupted and is unreadable, or you have selected a theme with broken dependencies. Revert to default settings?",Globals.name, fixsettings, cancelfixsettings)
	a.window.destory()
# Import the desktop integration (gconf tweaking) module
from DesktopIntegration import DesktopIntegration

# Define autocategories
Categories = Config.ThemeCategories
CategorySelection = {}
CurrentTreeDataSet = Categories[0]
KeysTab = {"115":"End","65":"Space","133":"WinKey","37":"Left Control","36":"Enter","64":"Left Alt","108":"Right Alt","105":"Right Alt","135":"Menu"}
DIModule = DesktopIntegration()


# Fixes a broken Config file if a bad theme has been selected
def destroy(event=None, anythingelse=None):
    # External Obliterator
    window.destroy()
    gtk.main_quit()
def LanguageChange(widget):
	global Language
	Dataset = widget.get_model()
	Index = widget.get_active()
	Language = Dataset[Index][0]
	LoadLanguage()
def ADComchange(widget, index, text):
	Widget = wTree.get_widget("ADCommands")
	ADtree_base = Widget.get_model()
	ADtree_base[index][2] = text
	Commands[ADtree_base[index][0]] = text	
def TreeSelChange(widget):
	global CurrentTreeDataSet
	#Identify which category area was picked
	Dataset = widget.get_model()
	Index = widget.get_cursor()
	#Save old values from widget
	SaveTreeSelValue()
	CurrentTreeDataSet = Dataset[Index[0][0]][0]
	LoadStylePreview(CurrentTreeDataSet)	
	#Load new values to widget
def DIvaluechanged(widget, index):
	Widget = wTree.get_widget("DITree")
	Dataset = Widget.get_model()
	Dataset[index][3] = not Dataset[index][3]
	if Dataset[index][3] == 1:
		DIModule.enable(index)
	else:
		DIModule.disable(index)
	Dataset[index][3] = DIModule.checkstate(index)
def SaveTreeSelValue(Widget=None,event=None):
	# Saves the theme selection to memory
	Widget = wTree.get_widget("THThmSelCombo")
	Dataset = Widget.get_model()
	Index = Widget.get_active()
	if Index >= 0 and Themes.has_key(CurrentTreeDataSet):
		CategorySelection[CurrentTreeDataSet] = Dataset[Index][0]
		Wid = wTree.get_widget("THAuthor-Text")
		Wid.set_text(str(Themes[CurrentTreeDataSet][Dataset[Index][0]]["Author"]))
		Wid = wTree.get_widget("THCop-Text").get_buffer()
		Wid.set_text(Themes[CurrentTreeDataSet][Dataset[Index][0]]["Copyright"])
#		if CurrentTreeDataSet == Categories[0]:
#			for type in Categories:
#				if type != CurrentTreeDataSet:
#					CategorySelection[type] = Themes[CurrentTreeDataSet][CategorySelection[CurrentTreeDataSet]][type]
				

def LoadStylePreview(type):
#	global Commands, Themes
	if not Themes.has_key(type):
		type = Categories[0]
	CurSel = CategorySelection[type]
	Widget = wTree.get_widget("THAuthor-Text")
	Widget.set_text(str(Themes[type][CurSel]["Author"]))
	Widget = wTree.get_widget("THCop-Text").get_buffer()
	Widget.set_text(Themes[type][CurSel]["Copyright"])	
	# Load registered components of specific type
	Widget = wTree.get_widget("THThmSelCombo")
	Dataset = Widget.get_model()
	Dataset.clear()
	global Themes
	for Folder in Themes[type].keys():
		try:
			Pixbuf = gtk.gdk.pixbuf_new_from_file(Config.ThemeDirectory + type +"/" + Folder + "/themepreview.png")
		except:
			Pixbuf = gtk.gdk.pixbuf_new_from_file(Config.GraphicsDirectory + "theme.png")
		Dataset.append([Folder,Themes[type][Folder]["Name"],Pixbuf])
		if Folder == CurSel:
				Widget.set_active(Themes[type].keys().index(Folder))
	
def LoadLanguage():
	global Language
	# Disable unavailable languages
	if os.path.isfile(Config.ProgramDirectory+"locale/Settings_LangPack_"+Language+".xml") == 0:
		print "Selected Language " + Language + " is unavailable, reverting to default"
		Language = Default_Language
	# Check theme availability and display appropriate icon
	WidgetName = "LAThmHasImg"
	Widget = wTree.get_widget(WidgetName)
	if os.path.isfile(Config.ImageDirectory+"themedata_" + Language + ".xml"):
		if Widget:
			Widget.set_from_file(Config.GraphicsDirectory+"selected.png")
		else:
			print "Recoverable Error: Widget not found: " + WidgetName
	else:
		if Widget:
			Widget.set_from_file(Config.GraphicsDirectory+"unselected.png")
		else:
			print "Recoverable Error: Widget not found: " + WidgetName
	# Load current language to widget values
	XMLLanguage = xml.dom.minidom.parse(Config.ProgramDirectory+"locale/Settings_LangPack_"+Language+".xml")
	XBase = XMLLanguage.childNodes[0]
	# Load Language to all buttons, labels and other widgets
	#Set Window Title
	SBase = XBase.getElementsByTagName("Window")
	if not Config.FirstUse and SBase:
		window.set_title(SBase[0].attributes["Text"].value)
	else:
		window.set_title(SBase[0].attributes["Text"].value+" " + Globals.name + " " + Globals.version+" "+SBase[0].attributes["WelcomeText"].value)

	# Set Labels
	SBase = XBase.getElementsByTagName("Label")
	for node in SBase:	
		Label = node.attributes["Text"].value
		WidgetName = node.attributes["Widget"].value
		Widget = wTree.get_widget(WidgetName)
		if Widget:
			Widget.set_text(Label)
		else:
			print "Recoverable Error: Widget not found: " + WidgetName
	# Set Expanders	
	SBase = XBase.getElementsByTagName("Expander")
	for node in SBase:	
		Label = node.attributes["Text"].value
		WidgetName = node.attributes["Widget"].value
		Widget = wTree.get_widget(WidgetName)
		if Widget:
			Widget.set_label(Label)
		else:
			print "Recoverable Error: Widget not found: " + WidgetName
		
	SBase = XBase.getElementsByTagName("Button")
	for node in SBase:	
		Label = node.attributes["Text"].value
		WidgetName = node.attributes["Widget"].value
		Widget = wTree.get_widget(WidgetName)
		if Widget:
			Widget.set_label(Label)
		else:
			print "Recoverable Error: Widget not found: " + WidgetName

	SBase = XBase.getElementsByTagName("Image")
	for node in SBase:	
		Filename = node.attributes["Image"].value
		WidgetName = node.attributes["Widget"].value
		Widget = wTree.get_widget(WidgetName)
		if Widget:
			Widget.set_from_file(Config.GraphicsDirectory+Filename)
		else:
			print "Recoverable Error: Widget not found: " + WidgetName

	SBase = XBase.getElementsByTagName("ToolTip")
	for node in SBase:	
		Name = node.attributes["Text"].value
		WidgetName = node.attributes["Widget"].value
		Widget = wTree.get_widget(WidgetName)
		if Widget:
			Widget.set_tooltip_text(Name)
		else:
			print "Recoverable Error: Widget not found: " + WidgetName
	# Set TreeView
	SBase = XBase.getElementsByTagName("Tree")
	for node in SBase:	
		Name = node.attributes["Text"].value
		id = node.attributes["Id"].value
		Widget = wTree.get_widget(node.attributes["Widget"].value)
		Type = node.attributes["Type"].value
		if Type == "row":
			Dataset = Widget.get_model()
			for i in Dataset:
				if i[0] == id:
					i[1] = Name
		elif Type == "column":
			Column = Widget.get_column(int(id))
			Column.set_title(Name)
#		window.set_title(Name)
#		Widget.set_model(Dataset)
#		elif loc == "Treeviewcolumn":
#			tree_column.set_title(Name)
#		elif loc == "DesktopIntegrationTable_Col":
#			DItree_column[int(id)].set_title(Name)
#		elif loc == "DesktopIntegrationTable_Cat":
#			Widget = wTree.get_widget("DITree")
#			Dataset = Widget.get_model()
#			Dataset[int(id)][1] = Name
#			Widget.set_model(Dataset)			
#		elif loc == "WindowTitle0":
#			if not Config.FirstUse:
#				window.set_title(Name)
#				# Fixme: Display welcome screen!
#		elif loc == "WindowTitle1":
#			if Config.FirstUse:
#				window.set_title(Name + " " + Globals.name + " " + Globals.version)
				# Fixme: Display welcome screen!
#		else:
#			print "Warning: Name location identifier not recognised from: " + node.toxml()

def SaveSettings():
	global Config
	#Language
	SBase = XBase.getElementsByTagName("Language")
	SBase[0].attributes["Language"].value = Language
	
	#Theme/Style Properties
	for type in Categories:
		SBase = XBase.getElementsByTagName(type)
		SBase[0].attributes["Name"].value = CategorySelection[type]
		
	SBase = XBase.getElementsByTagName("Command")
	for cmd in Commands.keys():
		SBase[Commands.keys().index(cmd)].attributes["Action"].value = cmd
		SBase[Commands.keys().index(cmd)].attributes["Exec"].value = Commands[cmd]
		

	#Advanced menu
	Widget = wTree.get_widget("ADWinKey")
	SBase = XBase.getElementsByTagName("SuperL")
	SBase[0].attributes["Enabled"].value = str(int(Widget.get_active()))
	SBase = XBase.getElementsByTagName("SuperL")
	SBase[0].attributes["Key"].value = str(SuperLkey)
#	Config.SuperLkey = SuperLkey
	Widget = wTree.get_widget("ListSize")
	SBase = XBase.getElementsByTagName("ListSize")
	SBase[0].attributes["ListSize"].value = str(float(Widget.get_value()))

	Widget = wTree.get_widget("IconSize")
	SBase = XBase.getElementsByTagName("IconSize")
	SBase[0].attributes["IconSize"].value = str(float(Widget.get_value()))

	Widget = wTree.get_widget("LBLShowIE")
	SBase = XBase.getElementsByTagName("ShowIE")
	SBase[0].attributes["Shownetandemail"].value = str(int(Widget.get_active()))
	
	file_object = open(Config.HomeDirectory+"/.VistaMenuSettings.xml","w") 
	file_object.write(XMLSettings.toxml())  
	file_object.close()

def OK_Pressed(widget,event):
	SaveSettings()
	gtk.main_quit()
def CA_Pressed(widget,event):
	gtk.main_quit()
def RV_Pressed(widget,event):
	LoadSettings()
	LoadSettings()
	LoadLanguage()


# Force global welcome event if directed to by user
if len(sys.argv) == 2 and sys.argv[1] == "--welcome":
	Config.FirstUse = True
	
# Set the Glade file
wTree = gtk.glade.XML(Config.GladeSettingsFile)
window = wTree.get_widget("settingswindow")
window.set_app_paintable(1)
window.set_skip_taskbar_hint(1)
window.set_skip_pager_hint(1)
window.set_keep_above(0)       #Make this always above other windows

def LoadThemes():
	global Themes
	# Load Themes
	Themes = {}
	for type in Categories:
		# Load Theme Settings
		SBase = XBase.getElementsByTagName(type)
		CategorySelection[type] = SBase[0].attributes["Name"].value
		def tdir(x):
			th = Config.ThemeDirectory + type +"/" + x
			if os.path.isdir(th) or os.path.isfile(th+"/themedata.xml") or os.path.isfile(th+"/themedata_"+Config.Language+".xml"):
				return 1
			else:
				return 0
		files = filter(tdir, os.listdir(Config.ThemeDirectory + type))
		Themes[type] = {}
		for i in files:
			if os.path.isfile(Config.ThemeDirectory  + type +"/"+i+"/themedata.xml") or os.path.isfile(Config.ThemeDirectory  + type +"/"+i+"/themedata_"+Language+".xml"):
				Themes[type][i] = {}
				try:
					XLSTheme = xml.dom.minidom.parse(Config.ThemeDirectory  + type +"/"+i+"/themedata.xml")
				except:
					XLSTheme = xml.dom.minidom.parse(Config.ThemeDirectory  + type +"/"+i+"/themedata_"+Language+".xml")
				SBase = XLSTheme.getElementsByTagName("Contentdata")
				if SBase.length == 0:
					SBase = XLSTheme.getElementsByTagName("ContentData")
					if SBase.length == 0:
						SBase = XLSTheme.getElementsByTagName("contentdata")
						if SBase.length == 0:
							SBase = XLSTheme.getElementsByTagName("CONTENTDATA")
#			if SBase == None:
#				SBase = XLSTheme.getElementsById("Contentdata")
				for att in ['Name','Author','Copyright']:
					Themes[type][i][att] = SBase[0].attributes[att].value
#			if type == Categories[0]:
#				SBase = XLSTheme.getElementsByTagName("Preset")
#				for pr in Categories:
#					if pr != type:
#						Themes[type][i][pr] = ""
			#			Themes[type+'/'+i+'/'+str(pr)] = ""#SBase[0].attributes[str(pr)].value
	#		SBase = XLSTheme.getElementsByTagName("theme")
	#		Themes[type][i]['theme'] = {}
#			Themes[type][i]['commands'] = {}
	#		for node in SBase:
	#			try:
	#				Themes[type][i]['theme'][node.attributes['color'].value] = node.attributes['color_lang'].value
#					Base = node.getElementsByTagName("Button")
#					for bt in Base:
#						cmd = bt.attributes["Command"].value
#						Name = bt.attributes["Name"].value
#						if Commands.has_key(cmd):
#							Themes[type][i][cmd] = Name
	


def LoadSettings():
	global Config	
	global XMLSettings,XBase,Themes,Language,Default_Language,SuperLkey
	#global tree_column, DItree_column
	# Load settings to memory
	XMLSettings = xml.dom.minidom.parse(Config.HomeDirectory+"/.VistaMenuSettings.xml")
	XBase = XMLSettings.childNodes[0].childNodes[1]

	# Load Language
	SBase = XBase.getElementsByTagName("Language")
	Language = SBase[0].attributes["Language"].value
	Default_Language = SBase[0].attributes["Default"].value
	#===================================
	#Load commands
	#===================================
	global Commands
	Commands = {}
	SBase = XBase.getElementsByTagName("Command")
	for node in SBase:
		Commands[node.attributes["Action"].value]=node.attributes["Exec"].value
	Widget = wTree.get_widget("ADCommands")
	ADtree_base = Widget.get_model()
	ADtree_base.clear()#Themes[type][CurSel]['commands']
	for cmd in Commands.keys():
			ADtree_base.append([cmd,cmd,Commands[cmd]])
	#Loading avalable themes
	LoadThemes()

	Widget = wTree.get_widget("LALangBox")
	# Load language list
	model_scrit = Widget.get_model()
	model_scrit.clear()

	def xmls(x): #Verify .xml is in string
		if x.find(".xml") !=-1:
			return 1
		else:
			return 0
	# Getting .xml files
	files = filter(xmls, os.listdir(Config.ProgramDirectory + "locale/"))
	# Create internal listing of availability
	for i in files:
		# Loading Lang from xml file
		XMLLang = xml.dom.minidom.parse(Config.ProgramDirectory+"locale/"+i)
		SBase = XMLLang.getElementsByTagName("OwnName")
		Name = SBase[0].attributes["Name"].value
		Lang = SBase[0].attributes["Identifier"].value
		try:
			Pixbuf = gtk.gdk.pixbuf_new_from_file(Config.ProgramDirectory + "locale/"+Lang+".png")
		except:
			print "Warning: Language icon for " + Name + " not found! Reverting to default."
			Pixbuf = gtk.gdk.pixbuf_new_from_file(Config.ProgramDirectory + "locale/default.png")
		if Lang != "" and Name != "":
			model_scrit.append([Lang,str(Name),Pixbuf])
		# Set the currently selected language as active
		if Lang == Language:
			Widget.set_active(files.index(i))

	#===================================
	# Set Values to Advanced Menu
	#===================================
	Widget = wTree.get_widget("ADWinKey")
	SBase = XBase.getElementsByTagName("SuperL")
	WinKeyVal = SBase[0].attributes["Enabled"].value
	Widget.set_active(int(WinKeyVal))
	SuperLkey = int(SBase[0].attributes["Key"].value)
	Widget = wTree.get_widget("ADKeyActivate")
	Widget.connect("pressed", wait_key)
   	if KeysTab.has_key(str(SuperLkey)):
    		Widget.set_label(Config.Lang['SuperLkey']+"<"+KeysTab[str(SuperLkey)]+">")
    	else:
    		Widget.set_label(Config.Lang['SuperLkey']+"<"+str(SuperLkey)+">")
 	Widget = wTree.get_widget("ListSize")
	SBase = XBase.getElementsByTagName("ListSize")
	ListSize = SBase[0].attributes["ListSize"].value
	Widget.set_value(float(ListSize))
	
	Widget = wTree.get_widget("IconSize")
	SBase = XBase.getElementsByTagName("IconSize")
	ListSize = SBase[0].attributes["IconSize"].value
	Widget.set_value(float(ListSize))

	Widget = wTree.get_widget("LBLShowIE")
	SBase = XBase.getElementsByTagName("ShowIE")
	ShowIE = SBase[0].attributes["Shownetandemail"].value
	Widget.set_active(int(ShowIE))
	
	#==================================
	# Populate Theme selection treeview
	#==================================
	Widget = wTree.get_widget("THTree")
	# Create internal listing of availability
	tree_base = Widget.get_model()
	tree_base.clear()
	# Add the base selection categories
	for i in Categories:
		tree_base.append([i,str(i)])
	#==================================
	# Configure theme selection list
	#==================================
	# Set initial combobox values
	LoadStylePreview(CurrentTreeDataSet)

	#===================================
	# Populate Desktop Integration Table
	#===================================
	Widget = wTree.get_widget("DITree")
	# Create table framework
	DItree_base = Widget.get_model()
	DItree_base.clear()
	for i in range(0,4):
		#a = gtk.ToggleButton("Hello")
		DItree_base.append([str(i),"[Feature Name]",None,DIModule.checkstate(i)])
	
	
def key_down (widget,event):
    global SuperLkey
    # Key down
    key = event.hardware_keycode
    Widget =wTree.get_widget("ADKeyActivate")
    if Widget.get_active():
    	if KeysTab.has_key(str(key)):
    		Widget.set_label(Config.Lang['SuperLkey']+"<"+KeysTab[str(key)]+">")
    	else:
    		Widget.set_label(Config.Lang['SuperLkey']+"<"+str(key)+">")
    	SuperLkey = key
    	Widget.set_active(False)
    if key == 9:
		gtk.main_quit()
		
        
def wait_key(*args):
    Widget =wTree.get_widget("ADKeyActivate")
    #if Widget.get_active():
    Widget.set_label(Config.Lang['SuperLpress'])
def InstallTheme(button):
    Widget = wTree.get_widget("THInstFile")
    File = str(Widget.get_filename())
#    window.set_title(str(Widget.get_filename()))
    if File.endswith(".tar.gz"):
    	os.system("tar -x -z --file='"+File+"' --directory='"+Config.ThemeDirectory+CurrentTreeDataSet+"/'")
    	LoadThemes()
    	LoadStylePreview(CurrentTreeDataSet)
def UnInstallTheme(button):
	Widget = wTree.get_widget("THDel")
	if Themes[CurrentTreeDataSet].keys().__len__() > 1:
		if os.path.isdir(Config.ThemeDirectory+CurrentTreeDataSet+"/"+CategorySelection[CurrentTreeDataSet]) and Widget.get_active():
			os.system("rm -rf '"+Config.ThemeDirectory+CurrentTreeDataSet+"/"+CategorySelection[CurrentTreeDataSet]+"'")
			del Themes[CurrentTreeDataSet][CategorySelection[CurrentTreeDataSet]]
			Sel = Themes[CurrentTreeDataSet].keys()
			CategorySelection[CurrentTreeDataSet] = Sel[0]
			LoadStylePreview(CurrentTreeDataSet)
			SaveSettings()
		#LoadThemes()
	

#==================================
# Connect main buttons
#==================================
Widget = wTree.get_widget("OK")
Widget.connect("button-press-event", OK_Pressed)
Widget = wTree.get_widget("CN")
Widget.connect("button-press-event", CA_Pressed)
Widget = wTree.get_widget("RV")
Widget.connect("button-press-event", RV_Pressed)

#==================================
# Populate Language combobox
#==================================
Widget = wTree.get_widget("LALangBox")
model_scrit = gtk.ListStore(str,str,gtk.gdk.Pixbuf)
Widget.set_model(model_scrit)
# Set how data should be displayed in the combobox
celltext = gtk.CellRendererText()
cellimage = gtk.CellRendererPixbuf()
Widget.pack_start(cellimage)
Widget.pack_start(celltext)
# Set so image is far left aligned
cellimage.set_property('xalign', 0)
Widget.add_attribute(celltext,'text',1)
Widget.add_attribute(cellimage, 'pixbuf',2)
# Connect event that user changes language
Widget.connect("changed",LanguageChange)


#===================================
# Populate Desktop Integration Table
#===================================
Widget = wTree.get_widget("THTree")
# Create table framework
THtree_base = gtk.ListStore(str,str)
Widget.set_model(THtree_base)
# Create a single column
tree_column = gtk.TreeViewColumn("111")
# Tell gtk what to render
celltext = gtk.CellRendererText()
tree_column.pack_start(celltext)
tree_column.add_attribute(celltext,'text',1)
Widget.append_column(tree_column)
Widget.set_cursor(0,tree_column)
Widget.connect("cursor-changed",TreeSelChange)
	
#==================================
# Configure theme selection list
#==================================

# Create list object
Widget = wTree.get_widget("THThmSelCombo")
theme_list = gtk.ListStore(str,str,gtk.gdk.Pixbuf)
Widget.set_model(theme_list)	
# Set how data should be displayed in the combobox
celltext = gtk.CellRendererText()
cellimage = gtk.CellRendererPixbuf()
Widget.pack_start(cellimage)
Widget.pack_start(celltext)
# Set so image is far left aligned
cellimage.set_property('xalign', 0)
celltext.set_property('xalign', 1)
Widget.add_attribute(celltext,'text',1)
Widget.add_attribute(cellimage, 'pixbuf',2)
Widget.connect("changed", SaveTreeSelValue)

#===================================
# Populate Desktop Integration Table
#===================================
Widget = wTree.get_widget("DITree")
# Create table framework
DItree_base = gtk.ListStore(str,str,gtk.gdk.Pixbuf,gobject.TYPE_BOOLEAN)
Widget.set_model(DItree_base)
# Create a single column
DItree_column = []
DItree_column.append(gtk.TreeViewColumn("[Feature]"))
DItree_column.append(gtk.TreeViewColumn("[Value]"))
DItree_column.append(gtk.TreeViewColumn("[Status]"))
for col in DItree_column:
	Widget.append_column(col)
# Tell gtk what to render
celltext = gtk.CellRendererText()
cellimage = gtk.CellRendererPixbuf()
cellbutton = gtk.CellRendererToggle()
cellbutton.set_property('activatable', True)
cellbutton.connect( 'toggled', DIvaluechanged)
DItree_column[0].pack_start(celltext)
DItree_column[0].add_attribute(celltext,'text',1)
DItree_column[1].pack_start(cellimage)
DItree_column[1].add_attribute(cellimage,'image',2)
DItree_column[2].pack_start(cellbutton)
DItree_column[2].add_attribute(cellbutton,'active',3)
Widget.connect("cursor-changed",TreeSelChange)	

Widget = wTree.get_widget("ADCommands")
# Create table framework
ADtree_base = gtk.ListStore(str,str,str)
Widget.set_model(ADtree_base)
# Create a single column
ADtree_column = []
ADtree_column.append(gtk.TreeViewColumn("Comaand"))
ADtree_column.append(gtk.TreeViewColumn("Exec"))
for col in ADtree_column:
	Widget.append_column(col)
# Tell gtk what to render
celltext = gtk.CellRendererText()
celEntry = gtk.CellRendererText()
celEntry.set_property('editable',True)
celEntry.set_property('editable-set',True)
celEntry.connect( 'edited', ADComchange)
ADtree_column[0].pack_start(celltext)
ADtree_column[0].add_attribute(celltext,'text',1)
ADtree_column[1].pack_start(celEntry)
ADtree_column[1].add_attribute(celEntry,'text',2)

#Install Button init
Widget = wTree.get_widget("THInst")
Widget.connect("pressed", InstallTheme)

Widget = wTree.get_widget("THUnInst")
Widget.connect("pressed", UnInstallTheme)
#Widget.connect("cursor-changed",TreeSelChange)

#ADtree_base.append(["11","11","THThmSelCombo"])	


#==================================
# Loading Settings to widgets
#==================================

LoadSettings()

#==================================
# Load language to widgets
#==================================
LoadLanguage()

# Get the Main Window, and connect the "destroy" event
if (window):
    dic = {"on_MainMenu_destroy_event" : gtk.main_quit}
    wTree.signal_autoconnect(dic)
#window.connect("key-press-event", key_down)
window.connect("destroy", destroy)
window.connect("key-press-event", key_down)
window.present()
gtk.main()
