#===========================================
# Image Directories and global menu settings
# By QB89Dragon 2007/8
# This does not run independently
#===========================================

import gtk
import Globals
import os
import xml.dom.minidom
import gconf
import sys
from DesktopIntegration import DesktopIntegration
# Fixme: Implement new component registration

# Set up global directories
HomeDirectory = os.path.expanduser("~")
ProgramDirectory = "/usr/lib/"+Globals.appdirname+"/" 
ThemeDirectory = "/usr/share/"+Globals.appdirname+"/Themes/"
GraphicsDirectory = "/usr/lib/"+Globals.appdirname+"/graphics/"  
GladeSettingsFile = "/usr/lib/"+Globals.appdirname+"/settings-window.glade"
# Definitions
ThemeCategories = ["Style","Menu","Icon","Button","Widget"]

# Load settings stored in XML
def ReloadSettings():
	# Loads the main configuration and settings file to their respective values
	global MenuActions, MenuCommands, Language, Default_Language, Isize,ListSize,ImageDirectory,Actions, IconTheme, IconDirectory, GladeFile,MenuButtonTheme,MenuButtonDirectory,ThemeColor,ShowTop,TransitionQ,TransitionS,PGTheme,Shownetandemail,PGThemeDirectory,FirstUse,SuperL,SuperLkey
	FirstUse = False
	if not os.path.isfile(HomeDirectory+"/.VistaMenuSettings.xml"):
		os.system("cp /usr/lib/"+Globals.appdirname+"/Settings_default.xml " + HomeDirectory + "/.VistaMenuSettings.xml")
		#Launch the welcome screen
		#os.system("/bin/sh -c '/usr/lib/"+Globals.appdirname+"/Vista-Menu-Settings.py --welcome' &")
		FirstUse = True
	XMLSettings = xml.dom.minidom.parse(HomeDirectory+"/.VistaMenuSettings.xml")
	XBase = XMLSettings.childNodes[0].childNodes[1]
	# Load Language
	SBase = XBase.getElementsByTagName("Language")
	Language = SBase[0].attributes["Language"].value
	Default_Language = SBase[0].attributes["Default"].value
	
	# Language loading strings
	global Lang
	Lang = {'Language': Language} 
	#Default Lang Strings
	Lang['PrefLabel'] = "_Preferences..."
	Lang['MenuEditLabel'] = "_Edit Menus..."
	Lang['AboutLabel'] = "_About..."
	Lang['MenuBack'] = "Back"
	Lang['MenuInternet'] = "Internet"
	Lang['MenuMail'] = "E-Mail"
	Lang['SuperLkey'] = "Key: "
	Lang['SuperLpress'] = "Press Key"
	Lang['DelThemeMsg'] = "Realy delete %s theme?"
	
	if os.path.isfile(ProgramDirectory+"locale/Settings_LangPack_"+Language+".xml") == 1:
		XSLLanguage = xml.dom.minidom.parse(ProgramDirectory+"locale/Settings_LangPack_"+Language+".xml")
		XSLBase = XSLLanguage.childNodes[0]#.getElementsByTagName("TextItems").childNodes[0]
		# Panel menu item language
		SBase = XSLBase.getElementsByTagName("item")
		for node in SBase:
			Lang[node.attributes["id"].value] = node.attributes["Text"].value



	# Load Icon Size
	SBase = XBase.getElementsByTagName("IconSize")
	Isize = SBase[0].attributes["IconSize"].value

	# Load ListSize
	SBase = XBase.getElementsByTagName("ListSize")
	ListSize = SBase[0].attributes["ListSize"].value

	# Win key activation
	SBase = XBase.getElementsByTagName("SuperL")
	SuperL = SBase[0].attributes["Enabled"].value
	SuperLkey = int(SBase[0].attributes["Key"].value)

	# Load Theme settings for various components (legacy)
	SBase = XBase.getElementsByTagName("Menu")
	Theme = SBase[0].attributes["Name"].value
	ThemeColor = SBase[0].attributes["Color"].value

	ImageDirectory = "/usr/share/"+Globals.appdirname+"/Themes/Menu/"+Theme+"/"

	SBase = XBase.getElementsByTagName("Icon")
	IconTheme = SBase[0].attributes["Name"].value
	IconDirectory = "/usr/share/"+Globals.appdirname+"/Themes/Icon/"+IconTheme+"/"

	SBase = XBase.getElementsByTagName("Button")
	MenuButtonTheme = SBase[0].attributes["Name"].value
	MenuButtonDirectory = "/usr/share/"+Globals.appdirname+"/Themes/Button/"+MenuButtonTheme+"/"
	ShowTop = int(SBase[0].attributes["ShowTop"].value)

	SBase = XBase.getElementsByTagName("Widget")
	PGTheme=SBase[0].attributes["Name"].value
	PGThemeDirectory="/usr/share/"+Globals.appdirname+"/Themes/Widget/"+PGTheme+"/"

	# Get Animation Settings
	SBase = XBase.getElementsByTagName("Animation")
	TransitionS = int(SBase[0].attributes["TransitionS"].value)
	TransitionQ = float(SBase[0].attributes["TransitionQ"].value)

	# Show net and email on menus
	SBase = XBase.getElementsByTagName("ShowIE")
	Shownetandemail=int(SBase[0].attributes["Shownetandemail"].value)

	# Load the menu commands
	MenuActions = []
	MenuCommands = []
	SBase = XBase.getElementsByTagName("Command")
	for node in SBase:
		MenuActions.append(node.attributes["Action"].value)
		MenuCommands.append(node.attributes["Exec"].value)

	#================================================================
	global PG_iconsize,RI_numberofitems
	#Size of icons in the program list (default is 24)
	PG_iconsize = int(float(Isize))
	#Recent Items Menu
	RI_numberofitems = int(float(ListSize))

	#================================================================
	# Variables created here FIXME: create object for this, it's messy like this!
	global StartMenuTemplate,ThemeColorCode,MenuWidth, MenuHeight, IconW, IconH, IconInX, IconInY, IconInW, IconInH, SearchX, SearchY, SearchW, SearchH, SearchIX, SearchIY, SearchInitialText, SearchBackground, SearchWidget, SearchWidgetPath, UserIconFrameOffsetX, UserIconFrameOffsetY,PG_buttonframe,PG_buttonframedimensions,MenuHasSearch, MenuHasIcon, MenuHasFade
	if os.path.isfile(ImageDirectory+"themedata_"+Language+".xml"):
		XMLSettings = xml.dom.minidom.parse(ImageDirectory+"themedata_"+Language+".xml")
	else:
		XMLSettings = xml.dom.minidom.parse(ImageDirectory+"themedata.xml")
	XContent = XMLSettings.childNodes[0].getElementsByTagName("theme")
	# Identify correct theme style element
	Found = 0
	for node in XContent:
		if node.attributes["color"].value == ThemeColor or node.attributes["color"].value == "All":
			XBase = node
			ThemeColorCode = node.attributes["colorvalue"].value
			Found = 1
	if Found==0:
		print "Error: Failed to find theme color:" + ThemeColor
		print "The available values are:"
		for node in XContent:
			print node.attributes["color"].value
		sys.exit()
		
	# Load Background Image
	SBase = XBase.getElementsByTagName("Background")
	StartMenuTemplate = SBase[0].attributes["Image"].value
	

	# Load WindowDimensions
	SBase = XBase.getElementsByTagName("WindowDimensions")
	MenuWidth = int(SBase[0].attributes["Width"].value)
	MenuHeight = int(SBase[0].attributes["Height"].value)

	# Load WindowDimensions
	SBase = XBase.getElementsByTagName("IconSettings")
	UserIconFrameOffsetX = int(SBase[0].attributes["X"].value)
	UserIconFrameOffsetY = int(SBase[0].attributes["Y"].value)
	IconW = int(SBase[0].attributes["Width"].value)
	IconH = int(SBase[0].attributes["Height"].value)
	IconInX = int(SBase[0].attributes["InsetX"].value)
	IconInY = int(SBase[0].attributes["InsetY"].value)
	IconInW = int(SBase[0].attributes["InsetWidth"].value)
	IconInH = int(SBase[0].attributes["InsetHeight"].value)

	# Load SearchBarSettings
	SBase = XBase.getElementsByTagName("SearchBarSettings")
	SearchWidget = SBase[0].attributes["Widget"].value
	if SearchWidget != "None":
		# Load universal values
		SearchX = int(SBase[0].attributes["X"].value)
		SearchY = int(SBase[0].attributes["Y"].value)
		SearchW = int(SBase[0].attributes["Width"].value)
		SearchH = int(SBase[0].attributes["Height"].value)
		# Load theme-only values
		if SearchWidget == "Custom":
			SearchIX = int(SBase[0].attributes["InsetX"].value) 
			SearchIY = int(SBase[0].attributes["InsetY"].value)
			SearchInitialText = SBase[0].attributes["InitialText"].value
			SearchBackground = SBase[0].attributes["Background"].value
			SearchWidgetPath = SBase[0].attributes["WidgetName"].value

	# Load ProgramListSettings
	SBase = XBase.getElementsByTagName("ProgramListSettings")
	PG_buttonframe = int(SBase[0].attributes["X"].value),int(SBase[0].attributes["Y"].value)
	PG_buttonframedimensions = int(SBase[0].attributes["Width"].value),int(SBase[0].attributes["Height"].value)

	# Load Capabilities
	SBase = XBase.getElementsByTagName("Capabilities")
	MenuHasSearch = int(SBase[0].attributes["HasSearch"].value)
	MenuHasIcon = int(SBase[0].attributes["HasIcon"].value)
	MenuHasFade = int(SBase[0].attributes["HasFadeTransition"].value)

	#Load Menu Button List
	global MenuButtonCount, MenuButtonNames, MenuButtonMarkup, MenuButtonNameOffsetX, MenuButtonNameOffsetY, MenuButtonCommands,MenuButtonX,MenuButtonY,MenuButtonImage, MenuButtonIcon, MenuButtonIconSel, MenuButtonSub,MenuButtonClose, MenuCairoIcon
	MenuButtons = XBase.getElementsByTagName("Button")
	MenuButtonCount = len(MenuButtons)
	MenuButtonNames = []
	MenuButtonMarkup = []
	MenuButtonNameOffsetX = []
	MenuButtonNameOffsetY = []
	MenuButtonX = []
	MenuButtonY = []
	MenuButtonImage = []
	MenuButtonIcon = []
	MenuButtonIconSel = []
	MenuCairoIcon = []
	MenuButtonSub = []
	MenuButtonCommands = []
	MenuButtonClose = []
	for node in MenuButtons:
		MenuButtonNames.append(node.attributes["Name"].value)
		MenuButtonMarkup.append(node.attributes["Markup"].value)
		MenuButtonNameOffsetX.append(int(node.attributes["TextX"].value))
		MenuButtonNameOffsetY.append(int(node.attributes["TextY"].value))
		MenuButtonImage.append(node.attributes["Image"].value)    	    	
		MenuButtonIcon.append(node.attributes["ButtonIcon"].value)    	    	
		MenuButtonIconSel.append(node.attributes["ButtonIconSel"].value)    	    	
		MenuCairoIcon.append(node.attributes["Icon"].value)    	    	
		MenuButtonX.append(int(node.attributes["ButtonX"].value))
		MenuButtonY.append(int(node.attributes["ButtonY"].value))
		MenuButtonCommands.append(node.attributes["Command"].value)
		MenuButtonSub.append(int(node.attributes["SubMenu"].value))
		MenuButtonClose.append(int(node.attributes["CloseMenu"].value))
	#================================================================
	global ButtonHasTop, ButtonHasBottom
	XMLSettings = xml.dom.minidom.parse(MenuButtonDirectory+"themedata.xml")
	XBase = XMLSettings.getElementsByTagName("theme")
	print repr(dir(XBase))
	ButtonHasTop = int(XBase[0].attributes["Top"].value)
	if ButtonHasTop==0:
		ShowTop=0
	try:
		ButtonHasBottom = int(XBase[0].attributes["Bottom"].value)
	except:
		ButtonHasBottom = 0
#	if event_type == gnomevfs.MONITOR_EVENT_CHANGED:
#		ReloadSettings()
#	elif event_type == gnomevfs.MONITOR_EVENT_DELETED:
#		gnomevfs.monitor_cancel(handle)
#monitor = FileMonitor(ConfigFile)
#monitor.connect("changed", lambda a, b,ev: ReMonit())
#monitor.open()

ReloadSettings()
#if os.path.isfile(ConfigFile):
#	monit = f_event.monitor_file(0)
#	monit.set_rate_limit(5000)
#	monit.connect("changed",ReloadSettings())

#Screen width/height
__screen = gtk.gdk.screen_get_default()
geom = gtk.gdk.Screen.get_monitor_geometry(__screen, 0)
screenwidth = geom.width
screenheight = geom.height

#Basemenu parse (saves the delay everytime the menu is opened)
BaseMenu=""
# Obtain OS default icon theme
gconf_client = gconf.client_get_default()
DefaultIconTheme = gconf_client.get_string("/desktop/gnome/interface/icon_theme")

# Check compositing status
DIModule = DesktopIntegration()
EnableCompositing = int(DIModule.checkcompositing())

#This overrides user icon settings for themes that do not support them

if EnableCompositing==0:
	MenuHasIcon=0
	ShowTop = 0

#Main Start Button
#States:
# 0 = Normal
# 1 = Glowing (mouse-over)
# 2 = Depressed
              
# Blue glowy orb main
StartButton = (MenuButtonDirectory+"start-here.png",
               MenuButtonDirectory+"start-here-glow.png",
               MenuButtonDirectory+"start-here-depressed.png")
               
# Blue glowy orb top part
StartButtonTop = (MenuButtonDirectory+"start-here-top.png",
                     MenuButtonDirectory+"start-here-top-glow.png",
                     MenuButtonDirectory+"start-here-top-depressed.png",
                     MenuButtonDirectory+"start-here-bottom.png",
                     MenuButtonDirectory+"start-here-bottom-glow.png",
                     MenuButtonDirectory+"start-here-bottom-depressed.png")

StartMenuXOffset = -2
StartMenuYOffset = 0

#User Image
UserImageFrame = ImageDirectory+"user-image-frame.png"
DefaultUserImage = IconDirectory+"no-user-image.png"
UserImage = os.getenv('HOME') + "/.face"
if os.path.isfile(UserImage) == 0:
    UserImage=DefaultUserImage

#Application logo
Applogo = GraphicsDirectory +"logo.png"
BrokenImage = PGThemeDirectory + "/brokenlink.png"

#Web and Email  FIXME This is not customisable
Browser = IconDirectory+"firefox_icon.png"
Email = IconDirectory+"thunderbird_icon.png"

M_CurrentIconSet = ""
elist = []
ebuttonnamelist = []
ebuttoniconlist = []
etypelist = []
        
