#!/usr/bin/env python
#==============================
# Cairo 4-part image compositer
# Version 2.00
# By QB89Dragon 2007/8
#==============================
import cairo
import gobject
import gtk
class CairoWindow:
    def __init__(self,w,h,ix,iy,iw,ih):
		# Create the window itself
		self.w = w
		self.h = h
		self.ix = ix
		self.iy = iy
		self.iw = iw
		self.ih = ih
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.window.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
		self.window.set_default_size(w,h)
		#Set window profile
		self.window.set_skip_taskbar_hint(1)
		self.window.set_skip_pager_hint(1)
		self.window.set_decorated(0)
		self.window.set_app_paintable(True)	#?? Unsure about this one in the context of cairo redraws!! FIXME
		self.window.set_title("")
		self.window.set_keep_above(1)
		self.window.stick()                 #Makes window appear on all desktops
        #Connect redraw-events
		self.window.connect('expose-event', self.Repaint)
		self.window.connect('screen-changed', self.screen_changed)
		self.window.connect('destroy', self.destroy)
		#self.ev_box2 = gtk.EventBox()
		#self.ev_box2.set_above_child (0)
		#self.ev_box2.set_visible_window(0)
		#self.window.add(self.ev_box2)
		#Create the image surfaces
		self.icon1=cairo.ImageSurface
		self.icon2=cairo.ImageSurface
		self.icon3=cairo.ImageSurface
		self.icon4=cairo.ImageSurface
		
		self.screen_changed(self.window)
		#self.window.show_all()

		self.iconopacity = [0,0,0,0]
		self.intrans = False 
		
    def transition(self,step, speed, rate, termination_event):
		self.step = step
		if self.intrans == False:
			self.intrans = True
			# Add timer
			gobject.timeout_add(speed,self.updatefade, termination_event, rate)
    	
    def updatefade(self, termination_event, rate):
		for i in range(0,len(self.iconopacity)):
			self.iconopacity[i] = self.iconopacity[i] + (rate*self.step[i])
			if (self.iconopacity[i]<=0 or self.iconopacity[i]>=1) and self.step[i]!=0:
				self.step[i]=0
				self.iconopacity[i]=int(self.iconopacity[i])
		self.Redraw()
		if self.step==[0,0,0,0]:
			self.intrans = False
			if termination_event:
				termination_event()
			return False
		return True
    
    def show_window(self):
    	self.window.show()

    def hide_window(self):
    	self.window.hide()
    	
    def screen_changed(self,widget):
		# Screen change event
		screen = widget.get_screen()
		colormap = screen.get_rgba_colormap()
		widget.set_colormap(colormap)
    
    def Repaint(self,widget,event):
    	self.Redraw()
    
    def Redraw(self):
    	if self.window.window:
			self.cr = self.window.window.cairo_create()
			self.cr.set_source_rgba(1.0, 1.0, 1.0, 0.0)
			self.cr.set_operator(cairo.OPERATOR_SOURCE) #DEST_ATOP
			self.surface = cairo.ImageSurface(cairo.FORMAT_ARGB32, self.w, self.h)
			self.cr2 = cairo.Context(self.surface)
			
			if isinstance(self.icon1,cairo.Surface):
				self.cr2.set_source_surface(self.icon1, 0, 0)
				self.cr2.paint_with_alpha(self.iconopacity[0])
			if isinstance(self.icon2,cairo.Surface):
				self.cr2.set_source_surface(self.icon2, self.ix, self.iy)				
				self.cr2.paint_with_alpha(self.iconopacity[1])
			if isinstance(self.icon3,cairo.Surface):
				self.cr2.set_source_surface(self.icon3, 0, 0)
				self.cr2.paint_with_alpha(self.iconopacity[2])
			if isinstance(self.icon4,cairo.Surface):
				self.cr2.set_source_surface(self.icon4, 0, 0)
				self.cr2.paint_with_alpha(self.iconopacity[3])
			
			self.cr.set_source_surface(self.surface, 0, 0)
			self.cr.paint()
        
    def move(self,x,y):
        # Relocate the window
        self.window.move(x,y)

	def resize(self,w,h):
		self.window.resize(w,h)

	def resizematch(self):
		self.w = self.icon1.get_width()
		self.h = self.icon1.get_height()
		self.window.resize(self.w,self.h)
    
    def destroy(self,event):
        # Remove the window
        self.window.destroy()
        gtk.main_quit()

    def update(self):
        # Update the screen profile on request
        self.screen_changed(self.window)
        
    def updateimage(self,index,imagefile):
	if imagefile.endswith(".png"):
		self.temp = cairo.ImageSurface.create_from_png(imagefile)
	else:
		# All .face files will load through this routine, even though they may be 'png' format
		self.temppixbuf = gtk.gdk.pixbuf_new_from_file(imagefile)
		# Resize the image and create the cairo surface to be used
		self.temp = cairo.ImageSurface(cairo.FORMAT_ARGB32, self.iw, self.ih)
		self.cr2 = cairo.Context(self.temp)
		w = float(self.iw)/float(self.temppixbuf.get_width())
		h = float(self.ih)/float(self.temppixbuf.get_height())
		self.cr2.scale(w,h)
		self.ct = gtk.gdk.CairoContext(self.cr2)
		self.ct.set_source_pixbuf(self.temppixbuf,0,0)
		self.ct.paint()

        # Update the graphic being displayed (first image has size priority)
	if index==0:
		self.icon1 = self.temp
	if index==1:
		self.icon2 = cairo.ImageSurface(cairo.FORMAT_ARGB32, self.w, self.h)
		self.cr2 = cairo.Context(self.icon2)
		w = float(self.iw)/float(self.temp.get_width())
		h = float(self.ih)/float(self.temp.get_height())
		self.cr2.scale(w,h)
		self.cr2.set_source_surface(self.temp, 0, 0)
		self.cr2.paint()
	if index==2:
		self.icon3 = self.temp
	if index==3:
		self.icon4 = self.temp
	self.Redraw()
