#Cairo Transparant Window
import pygtk
pygtk.require('2.0')
import cairo
#import pango
import gtk

class CairoButtonWindow():
    def __init__(self):
		#Initialise Button Top
		# Create the window itself
		self.aux_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.aux_window.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_MENU)
		#Set window properties
		self.aux_window.set_skip_taskbar_hint(1)
		self.aux_window.set_skip_pager_hint(1)
		self.aux_window.set_decorated(0)        #Remove window decorations
		self.aux_window.set_app_paintable(True)
		self.aux_window.set_title("")
		self.aux_window.set_keep_above(1)       #Make the orb top always above other windows
		self.aux_window.stick()                 #Make this appear on all desktops

		#Connect graphical events
		self.aux_window.connect('expose-event', self.Aux_win_screenchange)
		self.aux_window.connect('screen-changed', self.screen_changed)
		self.aux_window.connect('destroy', self.undestroy)
		#self.aux_window.connect("enter-notify-event", parent.select_box)
		#self.aux_window.connect("leave-notify-event", parent.deselect_box)
		self.eventbox = gtk.EventBox()
		#self.ev_box2.connect("button-press-event",parent.button_press)
		self.eventbox.set_above_child (0)
		self.eventbox.set_visible_window(0)
		self.aux_window.add(self.eventbox)

		#Set up cairo image objects
		self.icon = None #cairo.ImageSurface
		self.screen_changed(self.aux_window)

		#Show all gtk widgets
		self.aux_window.show_all()

    def show_window():
        self.aux_window.show()

    def hide_window():
        self.aux_window.hide()

    def screen_changed(self,widget):
        # Screen change event
        screen = widget.get_screen()
        colormap = screen.get_rgba_colormap()
        widget.set_colormap(colormap)

    def undestroy(self,event):
        #Callback for user window destroy (i.e. sporadic alt-f4 ing by the user)
        #self.parent.auxdestroyed()
        pass #FIXME

    def Aux_win_screenchange(self,widget, event):
        if self.icon:
            # Orb Top Screen change event
            self.cr = self.aux_window.window.cairo_create()
            self.cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent
            self.cr.set_operator(cairo.OPERATOR_SOURCE)
            # Draw the graphics
            print self.icon
            self.cr.set_source_surface(self.icon, 0, 0)
            self.cr.paint()
        
    def move(self,x,y):
        # Relocate the window
        self.aux_window.move(x,y)

    def destroy(self):
        # Remove the window
        self.aux_window.destroy()

    def update(self):
        # Update the screen profile on request
        self.screen_changed(self.aux_window)
        
    def updateimage(self,image):
        # Update the graphic being displayed (first image has size priority)
        self.icon = cairo.ImageSurface.create_from_png(image)
        self.w = self.icon.get_width()
        self.h = self.icon.get_height()
        self.aux_window.resize(self.w,self.h)

        #	def get_width(self):
        #		try:
        #			return self.icon.get_width()

    def get_height(self):
        if self.icon:
            return self.icon.get_height()
        else:
            print "!"
            return 0
