#!/usr/bin/env python
#================================================
# Base class for program lists
# Use this function template to create new themes
#================================================
#==============================
# PROGRAM LIST  GTK Basic V1.01
# By QB89Dragon 2007/8
#==============================
import sys
sys.path.append('/usr/lib/vistamenu/')
import Config

import pygtk
pygtk.require("2.0")
import gtk
from XDG import XDGMenu
import os
import gobject

class ProgramList:
	def __init__(self):
		#Create the Base Menu Template and an XDG menu object
		self.XDG = XDGMenu()

#=================================================================  
#GRAPHICAL CODE FOR MENU
#=================================================================  

	def ProgramListPopulate(self,Frame,Destroyer):
		self.BanFocusSteal = False
		self.Destroyer=Destroyer
		self.Frame=Frame
		self.ConstructGTKObjectsMenu(self.Frame)
		self.PopulateButtons()
        
	def ConstructGTKObjectsMenu(self, Frame):
		# Create components Frame -> ScrollFrame -> EventBox -> VBox -> Buttons
		self.PrevSelButtons = []
		self.PrevSelButton = -1
		self.ScrollFrame = gtk.ScrolledWindow()
		self.PLVBox = gtk.VBox(False)
		self.SFEB = gtk.EventBox()
		self.SFEB.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(Config.ThemeColorCode))
		#Configure the scrollframe
		self.ScrollFrame.set_size_request(Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])      
		self.ScrollFrame.set_shadow_type(gtk.SHADOW_NONE)
		self.ScrollFrame.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
		#Build structure
		self.ScrollFrame.add_with_viewport(self.SFEB)
		self.SFEB.add(self.PLVBox)
		self.Frame.put(self.ScrollFrame,Config.PG_buttonframe[0],Config.PG_buttonframe[1])
		#Show newly created widgets
		self.SFEB.show()
		self.PLVBox.show()
		self.ScrollFrame.show()

	def PopulateButtons(self):
		self.Buttonlist = []
		for i in range(0,len(self.XDG.L_Names)):
			if self.XDG.L_Types[i]==8:
				self.Buttonlist.append(self.AddSeparator())
			elif self.XDG.L_Types[i]==9:
				self.Buttonlist.append(self.AddLabel(self.XDG.L_Names[i]))
			else:
				self.Buttonlist.append(self.AddButton(self.XDG.L_Names[i],self.XDG.L_Icons[i],0))
		self.SetInputFocus()
		
	def AddButton(self,name,icon,bold):
		self.Button = gtk.Button(name)
		#40 for Fav Apps button
		iconfile=self.XDG.geticonfile(icon)
		if bold:
			pass
			#FIXME: make text bold on a button (seemingly impossible task for gtk)
			
		if iconfile:
			if os.path.isfile(iconfile) != 0:
				self.Pic = gtk.gdk.pixbuf_new_from_file_at_size(iconfile, Config.PG_iconsize, Config.PG_iconsize)
			else:
				self.Pic = gtk.gdk.pixbuf_new_from_file_at_size(Config.BrokenImage, Config.PG_iconsize, Config.PG_iconsize)
			self.Img = gtk.Image()
			self.Img.set_from_pixbuf(self.Pic)
			self.Button.set_alignment(0,0.5)
			self.Button.set_image(self.Img)
		self.PG_buttonwidth = Config.PG_buttonframedimensions[0] - 12
		self.Button.set_size_request(self.PG_buttonwidth, Config.PG_iconsize+8)
		self.Button.set_relief(gtk.RELIEF_NONE)
		self.PLVBox.pack_start(self.Button, True,True, 0)
		self.Button.connect("button-press-event", self.PGListButtonClick)
		self.Button.connect("key-press-event", self.PGListButtonKey)
		self.Button.show()
		return self.Button

	def AddLabel(self,name):
		self.Label = gtk.Label(name)
		self.PG_buttonwidth = Config.PG_buttonframedimensions[0] - 12
		self.Separator.set_size_request(self.PG_buttonwidth, 32)
		self.PLVBox.pack_start(self.Label, True,True, 0)
		self.Label.show()
		return self.Label

	def AddSeparator(self):
		self.Separator = gtk.HSeparator()
		self.PG_buttonwidth = Config.PG_buttonframedimensions[0] - 12
		self.Separator.set_size_request(self.PG_buttonwidth, 1)
		self.PLVBox.pack_start(self.Separator, True,True, 0)
		self.Separator.show()
		return self.Separator

	def PGListButtonClick(self, widget, event):
		self.index = self.Buttonlist.index(widget)
		self.ActivateButton()
		
	def ActivateButton(self):
		self.type = self.XDG.L_Types[self.index]
		a = self.XDG.ButtonClick(self.index)
		if a==1:
			self.Destroyer()
		for item in self.Buttonlist:
			item.destroy()
		self.PopulateButtons()

	def PGListButtonKey(self, widget, event):
		self.index = self.Buttonlist.index(widget)
		key = event.hardware_keycode
		#98 up    104 dn
		if key == 98:	#Up (menu loop-around)
			if self.index == 0:
				# Set timeout to call last button (as key press has not gone through yet)
				gobject.timeout_add(100,self.SetLastButton, self)
		elif key == 104:	#Down
			if self.index == len(self.XDG.L_Names)-1:
				# Set timeout to call last button (as key press has not gone through yet)
				gobject.timeout_add(100,self.SetFirstButton, self)
			
		elif key == 102:	#Right
			self.type = self.XDG.L_Types[self.index]
			if self.type == 0:
				self.ActivateButton()
				self.PrevSelButtons.append(self.index)
		elif key == 100:	#Left
			if self.XDG.PrevMenu:
				self.XDG.CallSpecialMenu(0)
				for item in self.Buttonlist:
					item.destroy()
				if self.PrevSelButtons:
					self.PrevSelButton = self.PrevSelButtons.pop()
				self.PopulateButtons()
		elif key == 36 or key == 65:	#Enter or Space
			self.ActivateButton()
		else:
			pass
			
	def SetInputFocus(self):
		# Give keyboard input focus to last item on list or to sub menu program group start
		if self.BanFocusSteal == False:
			if self.PrevSelButton == -1:
				if self.XDG.PrevMenu and len(self.XDG.L_Names) > 4 and self.XDG.searchresults==0:	
					self.Buttonlist[3].grab_focus()
				else:
					self.Buttonlist[len(self.XDG.L_Names)-1].grab_focus()
			else:
				self.Buttonlist[self.PrevSelButton].grab_focus()
				self.PrevSelButton = -1

	def SetFirstButton(self,event):
		self.Buttonlist[0].grab_focus()

	def SetLastButton(self,event):
		self.Buttonlist[len(self.XDG.L_Names)-1].grab_focus()

#=================================================================  
#EXTRA FUNCTION PASSTHROUGH TO XDG
#See XDG module for command opcodes
#=================================================================  

	def CallSpecialMenu(self,command,data=None):
		for item in self.Buttonlist:
			item.destroy()
		self.XDG.CallSpecialMenu(command,data)
		self.PopulateButtons()


	def destroy(self):
		self.XDG.destroy() #Allows XDG to de-initialse correctly (VERY IMPORTANT)

# Self Run for Testing only

def destroy(event=None):
	PGL.destroy()
	gtk.main_quit()

if __name__ == "__main__":
    window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    window.set_app_paintable(1)
    window.connect('destroy', destroy)
    frame = gtk.Fixed()
    Config.PG_buttonframe=[0,0]
    window.add(frame)
    window.set_default_size(Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])
    PGL = ProgramList()
    PGL.ProgramListPopulate(frame,destroy)
    window.show_all()
    gtk.main()
