#!/usr/bin/env python
#=================================================
# Base class for program lists
# Use this function template to create new themes
# This can be run as a standalone test environment
#=================================================
#==============================
# PROGRAM LIST  Cairo V1.00
# By QB89Dragon 2007/8
#==============================

import sys
sys.path.append('/usr/lib/vistamenu/')
import Config
import pygtk
pygtk.require("2.0")
import cairo
import pango
import gtk
import gobject
import math
from XDG import XDGMenu

class ProgramList:
	def __init__(self):
		#Create the Base Menu Template and an XDG menu object		
		self.XDG = XDGMenu()

#=================================================================  
#GRAPHICAL CODE FOR MENU
#=================================================================  

	def ProgramListPopulate(self,Frame,Destroyer):
		self.Destroyer=Destroyer
		self.Frame = Frame
		self.ConstructGTKObjectsMenu(Frame)
		
		#self.PopulateButtons()
        
	def ConstructGTKObjectsMenu(self, Frame):
		self.menu = CairoMenuObject()
		self.menu.set_events(gtk.gdk.POINTER_MOTION_MASK |
                              gtk.gdk.POINTER_MOTION_HINT_MASK |
                              gtk.gdk.BUTTON_PRESS_MASK)
		self.menu.connect("motion_notify_event", self.mousemove)
		self.menu.connect("button-press-event", self.buttonpress)
		self.menu.set_size_request(Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])      
		Frame.put(self.menu, Config.PG_buttonframe[0],Config.PG_buttonframe[1])
		Frame.show_all()
		self.menu.UpdateButtons(self.XDG.L_Names)
		self.menu.InitiateAnimation(1)
		gobject.timeout_add(10,self.UpdateAnimation)
		
	def UpdateAnimation(self):
		self.Frame.queue_draw_area(Config.PG_buttonframe[0],Config.PG_buttonframe[1],Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])
		#gtk.gdk.window_process_all_updates()
		if self.menu.inanimation==1:
			return True
		else:
			return False
		
	def mousemove(self,widget,event):
		a = self.menu.seltext
		self.menu.seltext=self.menu.Unmap(event.x,event.y)
		if a != self.menu.seltext:
			self.menu.UpdateButtons(self.XDG.L_Names)		
			self.Frame.queue_draw_area(Config.PG_buttonframe[0],Config.PG_buttonframe[1],Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])
	
	def buttonpress(self,widget,event):
		a=self.XDG.L_Types[self.menu.seltext]
		self.XDG.ButtonClick(self.menu.seltext)
		self.menu.NameBuffer = self.XDG.L_Names
		if a==0:		#forward menu movement
			self.menu.InitiateAnimation(2)
			gobject.timeout_add(10,self.UpdateAnimation)

		elif a==2:	#back menu movement
			self.menu.InitiateAnimation(3)
			gobject.timeout_add(10,self.UpdateAnimation)

#=================================================================  
#EXTRA FUNCTION PASSTHROUGH TO XDG
#See XDG module for command opcodes
#=================================================================  

	def CallSpecialMenu(self,command,data=None):
#		for item in self.Buttonlist:
#			item.destroy()
		self.XDG.CallSpecialMenu(command,data)
#		self.PopulateButtons()

		self.menu.UpdateButtons(self.XDG.L_Names)
		self.menu.InitiateAnimation(1)
		gobject.timeout_add(10,self.UpdateAnimation)
		

class CairoMenuObject(gtk.DrawingArea):
    def __init__(self):
		gtk.DrawingArea.__init__(self)
		self.connect("expose_event", self.expose)
		# Screen dimensions
		self.x,self.y=Config.PG_buttonframe[0],Config.PG_buttonframe[1]
		self.w,self.h=Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1]
		#Standard settings
		self.font_size=[] 
		#Animation status
		self.inanimation=0
		self.activitycount=0
		self.deffont_size=10
		self.seltext = 0
		#Motion registers
		self.leftshift=0
		self.inleftshift=0
		self.leftshifti=0
		
    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        # set a clip region for the expose event
        self.context.rectangle(event.area.x, event.area.y,event.area.width, event.area.height)
        self.context.clip()
        self.draw(self.context)
        return False
    
    	
    def draw(self, context):
		x,y,w,h=self.x,self.y,self.w,self.h
		# Update animation handlers
		# Left shift
		if self.inleftshift==1:
			self.leftshifti=self.leftshifti+0.2
			self.leftshift=self.leftshiftd * w - (self.leftshiftd * math.sin(self.leftshifti)*w)
			if self.leftshifti>=math.pi/2:
				self.inleftshift=0
				self.leftshift=0
				self.activitycount = self.activitycount - 1
				if self.activitycount==0:
					self.inanimation=0
					
			self.UpdateButtons(self.NameBuffer)
			
		#Draw flat gradient background
		pat = cairo.LinearGradient (x, y,  w, h)
		pat.add_color_stop_rgba (0, .5, .5, .5, 1)
		pat.add_color_stop_rgba (1, .3, .3, 1, 1)
		context.set_source(pat)
		context.paint()
		context.set_source_rgba(0,0,0,.1)
		context.move_to(0, 0)
		context.curve_to(0, 250, w, h-150, w,h)
		context.line_to(w,0)
		context.move_to(w,0)
		context.fill_preserve()
		#Paint the button text onto the draw surface
		if isinstance(self.textsurface,cairo.Surface):
			context.set_source_surface(self.textsurface,self.leftshift,0)
			context.paint()
		if self.leftshiftdlw==-1:
			context.set_source_surface(self.prevtextsurface,self.leftshift+w,0)
			context.paint()
		elif self.leftshiftdlw==1:
			context.set_source_surface(self.prevtextsurface,self.leftshift-w,0)
			context.paint()

    def UpdateButtons(self,L_Names):
    	#Draw the button page overlay
		self.NameBuffer = L_Names
		if len(self.font_size) != len(self.NameBuffer):
			self.font_size = []
			self.font_move = []
			self.font_movec = []
			for i in range(len(self.NameBuffer)):
				self.font_size.append(10)
				self.font_move.append(0)
				self.font_movec.append(0)
		
		x,y,w,h=self.x,self.y,self.w,self.h
		self.textsurface = cairo.ImageSurface(cairo.FORMAT_ARGB32, self.w, self.h)
		context = cairo.Context(self.textsurface)
		self.DrawButton(w,30)
		#Draw text col1
		context.select_font_face("Sans",cairo.FONT_SLANT_NORMAL,cairo.FONT_WEIGHT_BOLD)
		for i in range(0,len(L_Names)):
			context.set_source_surface(self.buttonsurface,0,y+i*32-40)
			context.paint()
			

			if i==self.seltext:
				context.set_font_size(self.font_size[i]+1)
				context.set_source_rgba(1,1,1,1)
				context.move_to(15-3,y+i*32-22)
				context.show_text (L_Names[i])
			else:
				context.set_font_size(self.font_size[i])
				context.set_source_rgba(0,0,0,1)
				context.move_to(15-3,y+i*32-22)
				context.show_text (L_Names[i])
			
    def Unmap(self,x,y):
    	#Reverse map a mouse location to a specific button
		i = int(((y+40)-self.y)/32)
		if i>len(self.NameBuffer)-1:
			i=len(self.NameBuffer)-1
		return i
		
    def DrawButton(self,w,h):
		x0=0
		y0=0
		radius=8
		x1=x0+w
		y1=y0+h
		self.buttonsurface = cairo.ImageSurface(cairo.FORMAT_ARGB32, self.w, self.h)
		context = cairo.Context(self.buttonsurface)
		context.move_to(x0, y0 + radius)
		context.curve_to(x0 , y0, x0 , y0, x0 + radius, y0)
		context.line_to(x1 - radius, y0)
		context.curve_to(x1, y0, x1, y0, x1, y0 + radius)
		context.line_to(x1 , y1 - radius)
		context.curve_to(x1, y1, x1, y1, x1 - radius, y1)
		context.line_to(x0 + radius, y1)
		context.curve_to(x0, y1, x0, y1, x0, y1- radius)
		 
		context.close_path()
		pat = cairo.LinearGradient (x0, y0,  x0, y1)
		pat.add_color_stop_rgba (0, .1, .1, 1, 1)
		pat.add_color_stop_rgba (1, 1, 1, 1, 1)
		context.set_source(pat)
		context.fill_preserve()
		context.set_source_rgba(0, 0, 0, 1)
		context.set_line_width(1.0)
		context.stroke()

    def InitiateAnimation(self,opcode,data=None):
		if opcode==0:		#Abort all and reset environment registers
			self.inanimation=0
			self.activitycount=0
			self.leftshift=0
		elif opcode==1:		#Leftshift
			self.activitycount=self.activitycount+1		#Animation activity
			self.inanimation=1							#Active animation flag
			self.leftshift=-self.w						#Initial offset
			self.leftshiftd=-1							#Page shift direction
			self.leftshifti=0							#Increment counter
			self.leftshiftdlw=0							#Display previous page, to what side
			self.inleftshift=1							#Animation specific activity flag
		elif opcode==2:		#Rightshift w/ pttl
			self.activitycount=self.activitycount+1
			self.inanimation=1
			self.leftshift=self.w
			self.leftshiftd=1
			self.leftshiftdlw=1
			self.leftshifti=0
			self.prevtextsurface=self.textsurface		#Backup previous text surface for frameshifting
			self.inleftshift=1
		elif opcode==3:		#Leftshift w/ pttr
			self.activitycount=self.activitycount+1
			self.inanimation=1
			self.leftshiftd=-1
			self.leftshift=-self.w
			self.leftshifti=0
			self.leftshiftdlw=-1
			self.prevtextsurface=self.textsurface
			self.inleftshift=1

def destroy(self):
	self.XDG.destroy() #Allows XDG to de-initialse correctly (VERY IMPORTANT)
	sys.exit
	
if __name__ == "__main__":
    window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    window.set_app_paintable(1)
    window.connect('destroy', destroy)
    frame = gtk.Fixed()
    Config.PG_buttonframe=[0,0]
    window.add(frame)
    window.set_default_size(Config.PG_buttonframedimensions[0],Config.PG_buttonframedimensions[1])
    PGL = ProgramList()
    PGL.ProgramListPopulate(frame,destroy)
    window.show_all()
    gtk.main()
