#!/bin/sh
#
# Vista Script
# oscarif
# Para cambiar la apariencia TuXP a TuXista
# http://tuxiber.info
#
# Todos los iconos e imagenes usados se han tomado de varios proyectos los cuales se encuentran
# principalmente en gnome-look.og, esta solo es una recopilación de estos proyectos y este
# script es para la automatización de la apariencia.
#
# Última modificación: 21/10/09
#

DIR=$(pwd)

if ! $(zenity --question --no-wrap --title "Vista" --text "Este script cambiará la apariencia del escritorio para que luzca como Vista\n ¿Desea continuar?") ; then
	echo "no"
	exit 0
fi

(

echo "# Cambiando la apariencia...."
mkdir $HOME/.themes
mkdir $HOME/.icons

# Iconos
cp VistaFiles/VistaIcons.tar.gz $HOME/.icons
cd $HOME/.icons
tar -xf VistaIcons.tar.gz
rm VistaIcons.tar.gz
gconftool-2 --set "/desktop/gnome/interface/icon_theme" --type string "nuoveXT-1.7"
gconftool-2 --set "/desktop/gnome/interface/icon_theme" --type string "Aero"
cd $DIR

# Cursores
cp VistaFiles/Cursors.tar.gz $HOME/.icons
cd $HOME/.icons
tar -xf Cursors.tar.gz
rm Cursors.tar.gz
gconftool-2 --set "/desktop/gnome/peripherals/mouse/cursor_theme" --type string "aero-drop"
cd $DIR

# GTK Theme
cp VistaFiles/LiNsta-GTK2.tar.gz $HOME/.themes
cd $HOME/.themes
tar -xf LiNsta-GTK2.tar.gz
rm LiNsta-GTK2.tar.gz
gconftool-2 --set "/desktop/gnome/interface/gtk_theme" --type string "LiNsta-GTK2"
cd $DIR

# Meacity Theme
cp VistaFiles/LiNsta-Black-Plastic.tar.gz $HOME/.themes
cd $HOME/.themes
tar -xf LiNsta-Black-Plastic.tar.gz
rm LiNsta-Black-Plastic.tar.gz
gconftool-2 --set "/apps/metacity/general/theme" --type string "LiNsta-Black-Plastic"
cd $DIR

# Imagen
cp VistaFiles/Vista.tar.gz $HOME/.themes
cd $HOME/.themes
tar -xf Vista.tar.gz
rm Vista.tar.gz
cd $DIR

# Toolbars
gconftool-2 --set "/desktop/gnome/interface/toolbar_style" --type string "icons"

# Nautilus
gconftool-2 --set "/apps/nautilus/preferences/side_pane_view" --type string "NautilusTreeSidebar"
gconftool-2 --set "/apps/nautilus/sidebar_panels/tree/show_only_directories" --type bool TRUE

# Iconos del Escritorio
gconftool-2 --set "/apps/nautilus/desktop/computer_icon_visible" --type bool TRUE
gconftool-2 --set "/apps/nautilus/desktop/computer_icon_name" --type string "Mi PC"
gconftool-2 --set "/apps/nautilus/desktop/home_icon_visible" --type bool TRUE
gconftool-2 --set "/apps/nautilus/desktop/home_icon_name" --type string "Mis Documentos"
gconftool-2 --set "/apps/nautilus/desktop/network_icon_visible" --type bool TRUE
gconftool-2 --set "/apps/nautilus/desktop/network_icon_name" --type string "Mis sitios de red"
gconftool-2 --set "/apps/nautilus/desktop/trash_icon_visible" --type bool TRUE
gconftool-2 --set "/apps/nautilus/desktop/trash_icon_name" --type string "Papelera de reciclaje"
gconftool-2 --set "/apps/nautilus/desktop/volumes_visible" --type bool FALSE

# Splash Screen
gconftool-2 --set "/apps/gnome-session/options/show_splash_screen" --type bool FALSE
#gconftool-2 --set "/apps/gnome-session/options/splash_image" --type string "$HOME/.themes/XPLuna/windowslogin.png"

# Fondo
gconftool-2 --set "/desktop/gnome/background/picture_filename" --type string "$HOME/.themes/Vista/wallpapers/vista-wallpaper.jpg"
gconftool-2 --set "/desktop/gnome/background/picture_options" --type string "stretched"

# Área de Trabajo
gconftool-2 --set "/apps/metacity/general/num_workspaces" --type int 1

echo "# Creando Paneles...."

# Crear Panel Nuevo
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/animation_speed" --type string "medium"
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/auto_hide" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/auto_hide_size" --type int 6
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/enable_animations" --type bool TRUE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/enable_arrows" --type bool TRUE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/enable_buttons" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/expand" --type bool TRUE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/hide_delay" --type int 500
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/monitor" --type int 0
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/name" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/orientation" --type string "bottom"
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/screen" --type int 0
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/size" --type int 32
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/unhide_delay" --type int 500 
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/x" --type int 0
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/x_centered" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/x_right" --type int 
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/y" --type int 0
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/y_bottom" --type  int 
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/y_centered" --type bool FALSE

gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/color" --type string "#ffffff"
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/fit" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/image" --type string "/home/"$USER"/.themes/Vista/Panels/Vista-Panel.png"
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/opacity" --type int 6000
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/rotate" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/stretch" --type bool FALSE
gconftool-2 --set "/apps/panel/toplevels/bottom_panel_0/background/type" --type string "image"

# Menu Inicio
gconftool-2 --set "/apps/panel/objects/object_0/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/objects/object_0/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/objects/object_0/bonobo_iid" --type string ""
gconftool-2 --set "/apps/panel/objects/object_0/custom_icon" --type string "/home/"$USER"/.themes/Vista/MenuButtons/Vista.png"
gconftool-2 --set "/apps/panel/objects/object_0/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/objects/object_0/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/objects/object_0/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/objects/object_0/object_type" --type string "menu-object"
gconftool-2 --set "/apps/panel/objects/object_0/panel_right_stick" --type bool FALSE
gconftool-2 --set "/apps/panel/objects/object_0/position" --type int 0
gconftool-2 --set "/apps/panel/objects/object_0/tooltip" --type string "Haga clic para iniciar"
gconftool-2 --set "/apps/panel/objects/object_0/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/objects/object_0/use_custom_icon" --type bool TRUE
gconftool-2 --set "/apps/panel/objects/object_0/use_menu_path" --type bool FALSE

# Mostrar Escritorio
gconftool-2 --set "/apps/panel/applets/applet_0/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/applets/applet_0/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_0/bonobo_iid" --type string "OAFIID:GNOME_ShowDesktopApplet"
gconftool-2 --set "/apps/panel/applets/applet_0/custom_icon" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_0/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_0/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_0/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/applets/applet_0/object_type" --type string "bonobo-applet"
gconftool-2 --set "/apps/panel/applets/applet_0/panel_right_stick" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_0/position" --type int 1
gconftool-2 --set "/apps/panel/applets/applet_0/tooltip" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_0/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/applets/applet_0/use_custom_icon" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_0/use_menu_path" --type bool FALSE

# Área de Ventanas
gconftool-2 --set "/apps/panel/applets/applet_1/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/applets/applet_1/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_1/bonobo_iid" --type string "OAFIID:GNOME_WindowListApplet"
gconftool-2 --set "/apps/panel/applets/applet_1/custom_icon" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_1/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_1/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_1/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/applets/applet_1/object_type" --type string "bonobo-applet"
gconftool-2 --set "/apps/panel/applets/applet_1/panel_right_stick" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_1/position" --type int 2
gconftool-2 --set "/apps/panel/applets/applet_1/tooltip" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_1/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/applets/applet_1/use_custom_icon" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_1/use_menu_path" --type bool FALSE

gconftool-2 --set "/apps/panel/applets/applet_1/prefs/display_all_workspaces" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_1/prefs/group_windows" --type string "never"
gconftool-2 --set "/apps/panel/applets/applet_1/prefs/maximum_size" --type int 4096
gconftool-2 --set "/apps/panel/applets/applet_1/prefs/minimum_size" --type int 50
gconftool-2 --set "/apps/panel/applets/applet_1/prefs/move_unminimized_windows" --type bool TRUE

# Área de Notificación
gconftool-2 --set "/apps/panel/applets/applet_2/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/applets/applet_2/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_2/bonobo_iid" --type string "OAFIID:GNOME_NotificationAreaApplet"
gconftool-2 --set "/apps/panel/applets/applet_2/custom_icon" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_2/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_2/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_2/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/applets/applet_2/object_type" --type string "bonobo-applet"
gconftool-2 --set "/apps/panel/applets/applet_2/panel_right_stick" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_2/position" --type int 3
gconftool-2 --set "/apps/panel/applets/applet_2/tooltip" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_2/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/applets/applet_2/use_custom_icon" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_2/use_menu_path" --type bool FALSE

# Control de Volumen
gconftool-2 --set "/apps/panel/applets/applet_3/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/applets/applet_3/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_3/bonobo_iid" --type string "OAFIID:GNOME_MixerApplet"
gconftool-2 --set "/apps/panel/applets/applet_3/custom_icon" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_3/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_3/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_3/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/applets/applet_3/object_type" --type string "bonobo-applet"
gconftool-2 --set "/apps/panel/applets/applet_3/panel_right_stick" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_3/position" --type int 2
gconftool-2 --set "/apps/panel/applets/applet_3/tooltip" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_3/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/applets/applet_3/use_custom_icon" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_3/use_menu_path" --type bool FALSE

# Reloj
gconftool-2 --set "/apps/panel/applets/applet_4/action_type" --type string "lock"
gconftool-2 --set "/apps/panel/applets/applet_4/attached_toplevel_id" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/bonobo_iid" --type string "OAFIID:GNOME_ClockApplet"
gconftool-2 --set "/apps/panel/applets/applet_4/custom_icon" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/launcher_location" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/locked" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/menu_path" --type string "applications:/"
gconftool-2 --set "/apps/panel/applets/applet_4/object_type" --type string "bonobo-applet"
gconftool-2 --set "/apps/panel/applets/applet_4/panel_right_stick" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/position" --type int 0
gconftool-2 --set "/apps/panel/applets/applet_4/tooltip" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/toplevel_id" --type string "bottom_panel_0"
gconftool-2 --set "/apps/panel/applets/applet_4/use_custom_icon" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/use_menu_path" --type bool FALSE

gconftool-2 --set "/apps/panel/applets/applet_4/prefs/config_tool" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/custom_format" --type string ""
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/expand_appointments" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/expand_birthdays" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/expand_tasks" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/expand_weather" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/format" --type string "12-hour"
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/gmt_time" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/hour_format" --type string "12"
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/internet_time" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/show_date" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/show_seconds" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/show_timezones" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/show_tooltip" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/show_week_numbers" --type bool TRUE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/unix_time" --type bool FALSE
gconftool-2 --set "/apps/panel/applets/applet_4/prefs/timezones/tz_id_list" --type list --list-type string "[]"

# Agregar Paneles Items
gconftool-2 --set "/apps/panel/general/applet_id_list" --type list --list-type string "[applet_0,applet_1,applet_2,applet_3,applet_4]"
gconftool-2 --set "/apps/panel/general/object_id_list" --type list --list-type string "[object_0]"
gconftool-2 --set "/apps/panel/general/toplevel_id_list" --type list --list-type string "[bottom_panel_0]"
 
echo "# Configurando el tema para GDM..."
# Tema de GDM
cp VistaFiles/vista-login.tar.gz /tmp 
cp VistaFiles/vistamenu.tar.gz /tmp 
cp VistaFiles/VistaSplashy.tar.gz /tmp 
gksudo -m "Introduce la contraseña de sudo/root para cambiar la pantalla de Login e instalar el nuevo menú de inicio" VistaFiles/GDMTheme.sh
rm /tmp/vista-login.tar.gz

killall gnome-panel
echo "# Finalizado."
) | zenity --progress --width 500 --height 300 --title "Cambiando apariencia a Vista" --text "Apariencia cambiada..." --pulsate 
